/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.history;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class HistoricDetailAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/oneTaskCase.cmmn").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryAfterStandaloneTaskVariableUpdates() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testSimpleVariableUpdateQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleVariableUpdateQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleVariableUpdateQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
    }

    public void testVariableUpdateQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 0);
    }

    public void testVariableUpdateQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 3);
    }

    public void testVariableUpdateQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryAfterCaseVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
    }

    public void testMixedQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 7);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testSimpleFormFieldQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleFormFieldQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleFormFieldQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 1);
    }

    public void testFormFieldQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 0);
    }

    public void testFormFieldQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 3);
    }

    public void testFormFieldQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 7);
    }

    public void testDetailQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testDetailQueryWithReadHistoryOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testDetailQueryWithReadHistoryOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 7);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    protected void verifyQueryResults(HistoricDetailQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

