/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationTestUtil;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class MissingAuthorizationMatcher
extends TypeSafeDiagnosingMatcher<MissingAuthorization> {
    private MissingAuthorization missing;

    private MissingAuthorizationMatcher(MissingAuthorization authorization) {
        this.missing = authorization;
    }

    public static Collection<Matcher<? super MissingAuthorization>> asMatchers(List<MissingAuthorization> missingAuthorizations) {
        ArrayList<Matcher<? super MissingAuthorization>> matchers = new ArrayList<Matcher<? super MissingAuthorization>>(missingAuthorizations.size());
        for (MissingAuthorization authorization : missingAuthorizations) {
            matchers.add((Matcher<? super MissingAuthorization>)new MissingAuthorizationMatcher(authorization));
        }
        return matchers;
    }

    protected static MissingAuthorization asMissingAuthorization(Authorization authorization) {
        String permissionName = null;
        String resourceId = null;
        String resourceName = null;
        for (Permission permission : authorization.getPermissions((Permission[])Permissions.values())) {
            if (permission == Permissions.NONE) continue;
            permissionName = permission.getName();
            break;
        }
        if (!"*".equals(authorization.getResourceId())) {
            resourceId = authorization.getResourceId();
        }
        Resource resource = AuthorizationTestUtil.getResourceByType(authorization.getResourceType());
        resourceName = resource.resourceName();
        return new MissingAuthorization(permissionName, resourceName, resourceId);
    }

    public static List<MissingAuthorization> asMissingAuthorizations(List<Authorization> authorizations) {
        ArrayList<MissingAuthorization> missingAuthorizations = new ArrayList<MissingAuthorization>();
        for (Authorization authorization : authorizations) {
            missingAuthorizations.add(MissingAuthorizationMatcher.asMissingAuthorization(authorization));
        }
        return missingAuthorizations;
    }

    protected boolean matchesSafely(MissingAuthorization item, Description mismatchDescription) {
        if (StringUtils.equals((String)this.missing.getResourceId(), (String)item.getResourceId()) && StringUtils.equals((String)this.missing.getResourceType(), (String)item.getResourceType()) && StringUtils.equals((String)this.missing.getViolatedPermissionName(), (String)item.getViolatedPermissionName())) {
            return true;
        }
        mismatchDescription.appendText("expected missing authorization: ").appendValue((Object)this.missing).appendValue((Object)" received: ").appendValue((Object)item);
        return false;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.missing);
    }
}

