/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.cmmn;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;

public class CaseTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/examples/cmmn/loan-application.cmmn"})
    public void testCreateCaseInstanceById() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinition.getId()).create();
        CaseTest.assertNotNull((Object)caseInstance);
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        CaseTest.assertNotNull((Object)instance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/cmmn/loan-application.cmmn"})
    public void testCreateCaseInstanceByKey() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        CaseTest.assertNotNull((Object)caseInstance);
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        CaseTest.assertNotNull((Object)instance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/cmmn/loan-application.cmmn"})
    public void testCaseExecutionQuery() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        CaseTest.assertNotNull((Object)caseInstance);
        List caseExecutions = this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstance.getId()).list();
        CaseTest.assertEquals((int)3, (int)caseExecutions.size());
        CaseExecution casePlanModelExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("CasePlanModel_1").singleResult();
        CaseTest.assertNotNull((Object)casePlanModelExecution);
        CaseExecution stageExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseTest.assertNotNull((Object)stageExecution);
        CaseExecution humanTaskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_6").singleResult();
        CaseTest.assertNotNull((Object)humanTaskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/cmmn/loan-application.cmmn"})
    public void testCaseInstanceQuery() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        CaseTest.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        CaseTest.assertNotNull((Object)caseInstance);
        List caseInstances = this.caseService.createCaseInstanceQuery().active().list();
        CaseTest.assertEquals((int)1, (int)caseInstances.size());
    }
}

