/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class HistoricIncidentQueryTest
extends PluggableProcessEngineTestCase {
    private static String PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByIncidentId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String incidentId = ((HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult()).getId();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().incidentId(incidentId);
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidIncidentId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.incidentId("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.incidentId("invalid").count());
        try {
            query.incidentId(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as incidentId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByIncidentType() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().incidentType("failedJob");
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidIncidentType() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.incidentType("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.incidentType("invalid").count());
        try {
            query.incidentType(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as incidentType.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByIncidentMessage() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().incidentMessage("Expected exception.");
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidIncidentMessage() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.incidentMessage("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.incidentMessage("invalid").count());
        try {
            query.incidentMessage(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as incidentMessage.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processDefinitionId(pi.getProcessDefinitionId());
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidProcessDefinitionId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.processDefinitionId("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.processDefinitionId("invalid").count());
        try {
            query.processDefinitionId(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as processDefinitionId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidProcessInsanceId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.processInstanceId("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.processInstanceId("invalid").count());
        try {
            query.processInstanceId(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as processInstanceId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().executionId(pi.getId());
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidExecutionId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.executionId("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.executionId("invalid").count());
        try {
            query.executionId(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as executionId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByActivityId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().activityId("theServiceTask");
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidActivityId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.activityId("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.activityId("invalid").count());
        try {
            query.activityId(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as activityId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByCauseIncidentId() {
        this.startProcessInstance("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult()).getId();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstanceId).singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().causeIncidentId(incident.getId());
        HistoricIncidentQueryTest.assertEquals((int)2, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)2L, (long)query.count());
    }

    public void testQueryByInvalidCauseIncidentId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.causeIncidentId("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.causeIncidentId("invalid").count());
        try {
            query.causeIncidentId(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as causeIncidentId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByRootCauseIncidentId() {
        this.startProcessInstance("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult()).getId();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstanceId).singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().rootCauseIncidentId(incident.getId());
        HistoricIncidentQueryTest.assertEquals((int)2, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)2L, (long)query.count());
    }

    public void testQueryByInvalidRootCauseIncidentId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.rootCauseIncidentId("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.rootCauseIncidentId("invalid").count());
        try {
            query.rootCauseIncidentId(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as rootCauseIncidentId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByConfiguration() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String configuration = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().configuration(configuration);
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidConfigurationId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)0, (int)query.configuration("invalid").list().size());
        HistoricIncidentQueryTest.assertEquals((long)0L, (long)query.configuration("invalid").count());
        try {
            query.configuration(null);
            HistoricIncidentQueryTest.fail((String)"It was possible to set a null value as configuration.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByOpen() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().open();
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidOpen() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        try {
            query.open().open();
            HistoricIncidentQueryTest.fail((String)"It was possible to set a the open flag twice.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByResolved() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().resolved();
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidResolved() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        try {
            query.resolved().resolved();
            HistoricIncidentQueryTest.fail((String)"It was possible to set a the resolved flag twice.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByDeleted() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().deleted();
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.list().size());
        HistoricIncidentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidDeleted() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        try {
            query.deleted().deleted();
            HistoricIncidentQueryTest.fail((String)"It was possible to set a the deleted flag twice.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryPaging() {
        this.startProcessInstances(PROCESS_DEFINITION_KEY, 4);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncidentQueryTest.assertEquals((int)4, (int)query.listPage(0, 4).size());
        HistoricIncidentQueryTest.assertEquals((int)1, (int)query.listPage(2, 1).size());
        HistoricIncidentQueryTest.assertEquals((int)2, (int)query.listPage(1, 2).size());
        HistoricIncidentQueryTest.assertEquals((int)3, (int)query.listPage(1, 4).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQuerySorting() {
        this.startProcessInstances(PROCESS_DEFINITION_KEY, 4);
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentId().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCreateTime().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByEndTime().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentType().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByExecutionId().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByActivityId().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessInstanceId().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessDefinitionId().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCauseIncidentId().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByRootCauseIncidentId().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByConfiguration().asc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentId().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCreateTime().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByEndTime().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentType().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByExecutionId().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByActivityId().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessInstanceId().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessDefinitionId().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCauseIncidentId().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByRootCauseIncidentId().desc()).list().size());
        HistoricIncidentQueryTest.assertEquals((int)4, (int)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByConfiguration().desc()).list().size());
    }

    protected void startProcessInstance(String key) {
        this.startProcessInstances(key, 1);
    }

    protected void startProcessInstances(String key, int numberOfInstances) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
        this.executeAvailableJobs();
    }
}

