/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class LegacyUserOperationLogTest
extends ResourceProcessEngineTestCase {
    public static final String USER_ID = "demo";

    public LegacyUserOperationLogTest() {
        super("org/camunda/bpm/engine/test/history/useroperationlog/enable.legacy.user.operation.log.camunda.cfg.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/history/useroperationlog/UserOperationLogTaskTest.testOnlyTaskCompletionIsLogged.bpmn20.xml"})
    public void testLogAllOperationWithAuthentication() {
        try {
            this.identityService.setAuthenticatedUserId(USER_ID);
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
            LegacyUserOperationLogTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "taskListenerCalled")));
            LegacyUserOperationLogTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "serviceTaskCalled")));
            UserOperationLogQuery query = this.userOperationLogQuery().userId(USER_ID);
            LegacyUserOperationLogTest.assertEquals((long)3L, (long)query.count());
            LegacyUserOperationLogTest.assertEquals((long)1L, (long)query.operationType("Complete").count());
            LegacyUserOperationLogTest.assertEquals((long)2L, (long)query.operationType("SetVariable").count());
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/useroperationlog/UserOperationLogTaskTest.testOnlyTaskCompletionIsLogged.bpmn20.xml"})
    public void testLogOperationWithoutAuthentication() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        LegacyUserOperationLogTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "taskListenerCalled")));
        LegacyUserOperationLogTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "serviceTaskCalled")));
        LegacyUserOperationLogTest.assertEquals((long)4L, (long)this.userOperationLogQuery().count());
        LegacyUserOperationLogTest.assertEquals((long)1L, (long)this.userOperationLogQuery().operationType("Complete").count());
        LegacyUserOperationLogTest.assertEquals((long)2L, (long)this.userOperationLogQuery().operationType("SetVariable").count());
        LegacyUserOperationLogTest.assertEquals((long)1L, (long)this.userOperationLogQuery().operationType("Create").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/useroperationlog/UserOperationLogTaskTest.testOnlyTaskCompletionIsLogged.bpmn20.xml"})
    public void testLogSetVariableWithoutAuthentication() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"aValue");
        LegacyUserOperationLogTest.assertEquals((long)2L, (long)this.userOperationLogQuery().count());
        LegacyUserOperationLogTest.assertEquals((long)1L, (long)this.userOperationLogQuery().operationType("SetVariable").count());
        LegacyUserOperationLogTest.assertEquals((long)1L, (long)this.userOperationLogQuery().operationType("Create").count());
    }

    protected UserOperationLogQuery userOperationLogQuery() {
        return this.historyService.createUserOperationLogQuery();
    }
}

