/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;

public class JobExecutorAcquireJobsByPriorityAndDueDateTest
extends AbstractJobExecutorAcquireJobsTest {
    @Override
    protected boolean isJobExecutorAcquireByPriority() {
        return true;
    }

    @Override
    protected boolean isJobExecutorPreferOldJobs() {
        return true;
    }

    public void testProcessEngineConfiguration() {
        ProcessEngineConfigurationImpl configuration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertFalse((boolean)configuration.isJobExecutorPreferTimerJobs());
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertTrue((boolean)configuration.isJobExecutorAcquireByDueDate());
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertTrue((boolean)configuration.isJobExecutorAcquireByPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobPrioProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/timerJobPrioProcess.bpmn20.xml"})
    public void testAcquisitionByPriorityAndDueDate() {
        String instance1 = this.startProcess("jobPrioProcess", "task1");
        this.incrementClock(1L);
        String instance2 = this.startProcess("jobPrioProcess", "task2");
        this.incrementClock(1L);
        String instance3 = this.startProcess("jobPrioProcess", "task1");
        this.incrementClock(1L);
        String instance4 = this.startProcess("jobPrioProcess", "task2");
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertEquals((int)4, (int)acquirableJobs.size());
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertEquals((String)instance1, (String)acquirableJobs.get(0).getProcessInstanceId());
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertEquals((String)instance3, (String)acquirableJobs.get(1).getProcessInstanceId());
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertEquals((String)instance2, (String)acquirableJobs.get(2).getProcessInstanceId());
        JobExecutorAcquireJobsByPriorityAndDueDateTest.assertEquals((String)instance4, (String)acquirableJobs.get(3).getProcessInstanceId());
    }
}

