/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.cmd.DeleteJobCmd;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.TweetExceptionHandler;
import org.camunda.bpm.engine.test.jobexecutor.TweetNestedCommandExceptionHandler;

public class JobExecutorCmdExceptionTest
extends PluggableProcessEngineTestCase {
    protected TweetExceptionHandler tweetExceptionHandler = new TweetExceptionHandler();
    protected TweetNestedCommandExceptionHandler nestedCommandExceptionHandler = new TweetNestedCommandExceptionHandler();

    public void setUp() throws Exception {
        this.processEngineConfiguration.getJobHandlers().put(this.tweetExceptionHandler.getType(), this.tweetExceptionHandler);
        this.processEngineConfiguration.getJobHandlers().put(this.nestedCommandExceptionHandler.getType(), this.nestedCommandExceptionHandler);
    }

    public void tearDown() throws Exception {
        this.processEngineConfiguration.getJobHandlers().remove(this.tweetExceptionHandler.getType());
        this.processEngineConfiguration.getJobHandlers().remove(this.nestedCommandExceptionHandler.getType());
        this.clearDatabase();
    }

    public void testJobCommandsWith2Exceptions() {
        this.createJob("tweet-exception");
        this.executeAvailableJobs();
        JobQuery query = this.managementService.createJobQuery().noRetriesLeft();
        JobExecutorCmdExceptionTest.assertEquals((long)0L, (long)query.count());
    }

    public void testJobCommandsWith3Exceptions() {
        this.tweetExceptionHandler.setExceptionsRemaining(3);
        this.createJob("tweet-exception");
        this.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().noRetriesLeft().singleResult();
        JobExecutorCmdExceptionTest.assertNotNull((Object)job);
        JobExecutorCmdExceptionTest.assertEquals((int)0, (int)job.getRetries());
    }

    public void testMultipleFailingJobs() {
        this.tweetExceptionHandler.setExceptionsRemaining(600);
        for (int i = 0; i < 40; ++i) {
            this.createJob("tweet-exception");
        }
        this.executeAvailableJobs();
        List jobList = this.managementService.createJobQuery().list();
        JobExecutorCmdExceptionTest.assertEquals((int)40, (int)jobList.size());
        for (Job job : jobList) {
            JobExecutorCmdExceptionTest.assertEquals((int)0, (int)job.getRetries());
        }
    }

    public void testJobCommandsWithNestedFailingCommand() {
        this.createJob("tweet-exception-nested");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobExecutorCmdExceptionTest.assertEquals((int)3, (int)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
            JobExecutorCmdExceptionTest.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        JobExecutorCmdExceptionTest.assertEquals((int)2, (int)job.getRetries());
        this.executeAvailableJobs();
        job = (Job)this.managementService.createJobQuery().noRetriesLeft().singleResult();
        JobExecutorCmdExceptionTest.assertNotNull((Object)job);
        JobExecutorCmdExceptionTest.assertEquals((int)0, (int)job.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobFailingOnFlush.bpmn20.xml"})
    public void testJobRetriesDecrementedOnFailedFlush() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobExecutorCmdExceptionTest.assertNotNull((Object)job);
        JobExecutorCmdExceptionTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        job = (Job)this.managementService.createJobQuery().singleResult();
        JobExecutorCmdExceptionTest.assertNotNull((Object)job);
        JobExecutorCmdExceptionTest.assertEquals((int)0, (int)job.getRetries());
    }

    protected void createJob(final String handlerType) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = JobExecutorCmdExceptionTest.this.createMessage(handlerType);
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
    }

    protected MessageEntity createMessage(String handlerType) {
        MessageEntity message = new MessageEntity();
        message.setJobHandlerType(handlerType);
        return message;
    }

    protected void clearDatabase() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getManagementService().createJobQuery().list();
                for (Job job : jobs) {
                    new DeleteJobCmd(job.getId()).execute(commandContext);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                }
                List historicIncidents = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)historicIncident);
                }
                List historicJobLogs = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getHistoryService().createHistoricJobLogQuery().list();
                for (HistoricJobLog historicJobLog : historicJobLogs) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(historicJobLog.getId());
                }
                return null;
            }
        });
    }
}

