/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.metrics;

import java.util.Map;
import org.camunda.bpm.engine.test.metrics.AbstractMetricsTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;

public class ExecutedDecisionElementsMetricsTest
extends AbstractMetricsTest {
    public static final String DMN_FILE = "org/camunda/bpm/engine/test/metrics/ExecutedDecisionElementsTest.dmn11.xml";
    public static VariableMap VARIABLES = Variables.createVariables().putValue("status", (Object)"").putValue("sum", (Object)100);

    @Override
    protected void clearMetrics() {
        super.clearMetrics();
        this.processEngineConfiguration.getDmnEngineConfiguration().getEngineMetricCollector().clearExecutedDecisionElements();
    }

    public void testBusinessRuleTask() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"testProcess").startEvent().businessRuleTask("task").endEvent().done();
        BusinessRuleTask task = (BusinessRuleTask)modelInstance.getModelElementById("task");
        task.setCamundaDecisionRef("decision");
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).addClasspathResource(DMN_FILE).deploy().getId();
        ExecutedDecisionElementsMetricsTest.assertEquals((long)0L, (long)this.getExecutedDecisionElements());
        ExecutedDecisionElementsMetricsTest.assertEquals((long)0L, (long)this.getExecutedDecisionElementsFromDmnEngine());
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)VARIABLES);
        ExecutedDecisionElementsMetricsTest.assertEquals((long)16L, (long)this.getExecutedDecisionElements());
        ExecutedDecisionElementsMetricsTest.assertEquals((long)16L, (long)this.getExecutedDecisionElementsFromDmnEngine());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        ExecutedDecisionElementsMetricsTest.assertEquals((long)16L, (long)this.getExecutedDecisionElements());
        ExecutedDecisionElementsMetricsTest.assertEquals((long)16L, (long)this.getExecutedDecisionElementsFromDmnEngine());
    }

    protected long getExecutedDecisionElements() {
        return this.managementService.createMetricsQuery().name("executed-decision-elements").sum();
    }

    protected long getExecutedDecisionElementsFromDmnEngine() {
        return this.processEngineConfiguration.getDmnEngineConfiguration().getEngineMetricCollector().getExecutedDecisionElements();
    }
}

