/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.metrics;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.CallerRunsRejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.metrics.AbstractMetricsTest;
import org.camunda.bpm.engine.variable.Variables;

public class JobExecutorMetricsTest
extends AbstractMetricsTest {
    protected JobExecutor jobExecutor;
    protected ThreadPoolExecutor jobThreadPoolExecutor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.jobExecutor = this.processEngineConfiguration.getJobExecutor();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.processEngineConfiguration.setJobExecutor(this.jobExecutor);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    public void testJobAcquisitionMetricReporting() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        this.waitForJobExecutorToProcessAllJobs(5000L);
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        long acquisitionAttempts = this.managementService.createMetricsQuery().name("job-acquisition-attempt").sum();
        JobExecutorMetricsTest.assertTrue((acquisitionAttempts >= 1L ? 1 : 0) != 0);
        long acquiredJobs = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        JobExecutorMetricsTest.assertEquals((long)3L, (long)acquiredJobs);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    public void testCompetingJobAcquisitionMetricReporting() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        ControllableJobExecutor jobExecutor1 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        ControllableJobExecutor jobExecutor2 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        ConcurrencyTestCase.ThreadControl jobAcquisitionThread1 = jobExecutor1.getAcquisitionThreadControl();
        ConcurrencyTestCase.ThreadControl jobAcquisitionThread2 = jobExecutor2.getAcquisitionThreadControl();
        jobExecutor1.start();
        jobAcquisitionThread1.waitForSync();
        jobAcquisitionThread1.makeContinueAndWaitForSync();
        jobExecutor2.start();
        jobAcquisitionThread2.waitForSync();
        jobAcquisitionThread2.makeContinueAndWaitForSync();
        jobAcquisitionThread1.makeContinueAndWaitForSync();
        jobAcquisitionThread2.makeContinueAndWaitForSync();
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        long acquisitionAttempts = this.managementService.createMetricsQuery().name("job-acquisition-attempt").sum();
        JobExecutorMetricsTest.assertEquals((long)4L, (long)acquisitionAttempts);
        long acquiredJobs = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        JobExecutorMetricsTest.assertEquals((long)3L, (long)acquiredJobs);
        long acquiredJobsFailure = this.managementService.createMetricsQuery().name("job-acquired-failure").sum();
        JobExecutorMetricsTest.assertEquals((long)3L, (long)acquiredJobsFailure);
        jobExecutor1.shutdown();
        jobExecutor2.shutdown();
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    public void testJobExecutionMetricReporting() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        for (i = 0; i < 2; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        }
        this.waitForJobExecutorToProcessAllJobs(5000L);
        long jobsSuccessful = this.managementService.createMetricsQuery().name("job-successful").sum();
        JobExecutorMetricsTest.assertEquals((long)3L, (long)jobsSuccessful);
        long jobsFailed = this.managementService.createMetricsQuery().name("job-failed").sum();
        JobExecutorMetricsTest.assertEquals((long)6L, (long)jobsFailed);
        long jobCandidatesForAcquisition = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        JobExecutorMetricsTest.assertEquals((long)9L, (long)jobCandidatesForAcquisition);
    }

    @Deployment
    public void testJobExecutionMetricExclusiveFollowUp() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("exclusiveServiceTasksProcess");
        }
        this.waitForJobExecutorToProcessAllJobs(5000L);
        long jobsSuccessful = this.managementService.createMetricsQuery().name("job-successful").sum();
        JobExecutorMetricsTest.assertEquals((long)6L, (long)jobsSuccessful);
        long jobsFailed = this.managementService.createMetricsQuery().name("job-failed").sum();
        JobExecutorMetricsTest.assertEquals((long)0L, (long)jobsFailed);
        long jobCandidatesForAcquisition = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        JobExecutorMetricsTest.assertEquals((long)3L, (long)jobCandidatesForAcquisition);
        long exclusiveFollowupJobs = this.managementService.createMetricsQuery().name("job-locked-exclusive").sum();
        JobExecutorMetricsTest.assertEquals((long)3L, (long)exclusiveFollowupJobs);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    public void testJobRejectedExecutionMetricReporting() {
        RejectingJobExecutor rejectingExecutor = new RejectingJobExecutor();
        this.processEngineConfiguration.setJobExecutor((JobExecutor)rejectingExecutor);
        rejectingExecutor.registerProcessEngine((ProcessEngineImpl)this.processEngine);
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        this.waitForJobExecutorToProcessAllJobs(5000L);
        long numRejectedJobs = this.managementService.createMetricsQuery().name("job-execution-rejected").sum();
        JobExecutorMetricsTest.assertEquals((long)3L, (long)numRejectedJobs);
    }

    public static class RejectingJobExecutor
    extends DefaultJobExecutor {
        public RejectingJobExecutor() {
            ArrayBlockingQueue threadPoolQueue = new ArrayBlockingQueue(this.queueSize);
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, threadPoolQueue){

                @Override
                public void execute(Runnable command) {
                    throw new RejectedExecutionException();
                }
            };
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
            this.rejectedJobsHandler = new CallerRunsRejectedJobsHandler();
        }
    }
}

