/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.pvm;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.cmd.FoxDeleteProcessInstanceCmd;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.pvm.EventCollector;
import org.camunda.bpm.engine.test.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.pvm.activities.EmbeddedSubProcess;
import org.camunda.bpm.engine.test.pvm.activities.End;
import org.camunda.bpm.engine.test.pvm.activities.ParallelGateway;
import org.camunda.bpm.engine.test.pvm.activities.WaitState;

public class PvmEventTest
extends PvmTestCase {
    public void testStartEndEvents() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("events").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).startTransition("end").executionListener((ExecutionListener)eventCollector).endTransition().endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(events)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("take on (start)-->(end)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on ProcessDefinition(events)");
        PvmEventTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
    }

    public void testEmbeddedSubProcessEvents() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("events").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(events)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(embeddedsubprocess)");
        expectedEvents.add("start on Activity(startInside)");
        expectedEvents.add("end on Activity(startInside)");
        expectedEvents.add("start on Activity(endInside)");
        expectedEvents.add("end on Activity(endInside)");
        expectedEvents.add("end on Activity(embeddedsubprocess)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on ProcessDefinition(events)");
        PvmEventTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
    }

    public void testSimpleAutmaticConcurrencyEvents() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("events").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("c1").transition("c2").endActivity().createActivity("c1").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(events)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(fork)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(c2)");
        expectedEvents.add("end on Activity(c2)");
        expectedEvents.add("start on Activity(join)");
        expectedEvents.add("start on Activity(c1)");
        expectedEvents.add("end on Activity(c1)");
        expectedEvents.add("start on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on ProcessDefinition(events)");
        PvmEventTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
    }

    public void testEmbeddedSubProcessEventsDelete() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("events").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("taskInside").endActivity().createActivity("taskInside").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ExecutionImpl execution = (ExecutionImpl)processInstance;
        FoxDeleteProcessInstanceCmd cmd = new FoxDeleteProcessInstanceCmd(null, null);
        List collectExecutionToDelete = cmd.collectExecutionToDelete((PvmExecutionImpl)execution);
        for (PvmExecutionImpl interpretableExecution : collectExecutionToDelete) {
            interpretableExecution.deleteCascade2("");
        }
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(events)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(embeddedsubprocess)");
        expectedEvents.add("start on Activity(startInside)");
        expectedEvents.add("end on Activity(startInside)");
        expectedEvents.add("start on Activity(taskInside)");
        expectedEvents.add("end on Activity(taskInside)");
        expectedEvents.add("end on Activity(embeddedsubprocess)");
        expectedEvents.add("end on ProcessDefinition(events)");
        PvmEventTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
    }
}

