/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.camunda.bpm.engine.impl.runtime;

import java.util.List;

import org.camunda.bpm.engine.impl.interceptor.CommandContext;

/**
 * @author Thorben Lindhauer
 * @author Daniel Meyer
 * @author Michael Scholz
 */
public interface CorrelationHandler {

  /**
   * Correlate the given message and return the {@link MessageCorrelationResult} that matches it.
   * Return null if the message could not be correlated.
   *
   * @param commandContext
   * @param messageName
   * @param correlationSet any of its members may be <code>null</code>
   * @return
   */
  public MessageCorrelationResult correlateMessage(CommandContext commandContext, String messageName, CorrelationSet correlationSet);

  /**
   * Correlate all given messages and return a {@link List} of {@link MessageCorrelationResult}s that matches them.
   * Return any empty {@link List} if no message could not be correlated.
   *
   * @param commandContext
   * @param messageName
   * @param correlationSet any of its members may be <code>null</code>
   * @return
   */
  public List<MessageCorrelationResult> correlateMessages(CommandContext commandContext, String messageName, CorrelationSet correlationSet);

}
