/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.delegate;

import junit.framework.TestCase;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.api.delegate.AssertingJavaDelegate;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;

public class DelegateExecutionHierarchyTest
extends PluggableProcessEngineTestCase {
    protected void tearDown() throws Exception {
        AssertingJavaDelegate.clear();
        super.tearDown();
    }

    public void testSingeNonScopeActivity() {
        this.deployment(new BpmnModelInstance[]{((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done()});
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                TestCase.assertEquals((Object)execution, (Object)execution.getProcessInstance());
                TestCase.assertNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    public void testConcurrentServiceTasks() {
        this.deployment(new BpmnModelInstance[]{((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().parallelGateway("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).parallelGateway("join").endEvent().moveToNode("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).connectTo("join").done()});
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                TestCase.assertFalse((boolean)execution.equals(execution.getProcessInstance()));
                TestCase.assertNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    public void testTaskInsideEmbeddedSubprocess() {
        this.deployment(new BpmnModelInstance[]{((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().subProcess().embeddedSubProcess().startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().subProcessDone().endEvent().done()});
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                TestCase.assertFalse((boolean)execution.equals(execution.getProcessInstance()));
                TestCase.assertNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    public void testSubProcessInstance() {
        this.deployment(new BpmnModelInstance[]{((CallActivityBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().callActivity().calledElement("testProcess2")).endEvent().done(), ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess2").startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done()});
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                TestCase.assertTrue((boolean)execution.equals(execution.getProcessInstance()));
                TestCase.assertNotNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }
}

