/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.dmn;

import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class DecisionServiceTest
extends PluggableProcessEngineTestCase {
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DMN_FILE_SECOND_VERSION = "org/camunda/bpm/engine/test/api/dmn/Example_v2.dmn";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String RESULT_OF_FIRST_VERSION = "ok";
    protected static final String RESULT_OF_SECOND_VERSION = "notok";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testEvaluateDecisionById() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableById(decisionDefinition.getId(), (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testEvaluateDecisionByKey() {
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testEvaluateDecisionByKeyAndLatestVersion() {
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DMN_FILE_SECOND_VERSION).deploy().getId();
        try {
            DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
            this.assertThatDecisionHasResult(decisionResult, RESULT_OF_SECOND_VERSION);
        }
        finally {
            this.repositoryService.deleteDeployment(secondDeploymentId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testEvaluateDecisionByKeyAndVersion() {
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DMN_FILE_SECOND_VERSION).deploy().getId();
        try {
            DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, Integer.valueOf(1), (Map)this.createVariables());
            this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
        }
        finally {
            this.repositoryService.deleteDeployment(secondDeploymentId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testEvaluateDecisionByKeyAndNullVersion() {
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DMN_FILE_SECOND_VERSION).deploy().getId();
        try {
            DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, null, (Map)this.createVariables());
            this.assertThatDecisionHasResult(decisionResult, RESULT_OF_SECOND_VERSION);
        }
        finally {
            this.repositoryService.deleteDeployment(secondDeploymentId, true);
        }
    }

    public void testEvaluateDecisionByNullId() {
        try {
            this.decisionService.evaluateDecisionTableById(null, null);
            DecisionServiceTest.fail((String)"expect exception");
        }
        catch (NotValidException e) {
            this.assertTextPresent("decision definition id is null", e.getMessage());
        }
    }

    public void testEvaluateDecisionByNonExistingId() {
        try {
            this.decisionService.evaluateDecisionTableById("unknown", null);
            DecisionServiceTest.fail((String)"expect exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("no deployed decision definition found with id 'unknown'", e.getMessage());
        }
    }

    public void testEvaluateDecisionByNullKey() {
        try {
            this.decisionService.evaluateDecisionTableByKey(null, null);
            DecisionServiceTest.fail((String)"expect exception");
        }
        catch (NotValidException e) {
            this.assertTextPresent("decision definition key is null", e.getMessage());
        }
    }

    public void testEvaluateDecisionByNonExistingKey() {
        try {
            this.decisionService.evaluateDecisionTableByKey("unknown", null);
            DecisionServiceTest.fail((String)"expect exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("no decision definition deployed with key 'unknown'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testEvaluateDecisionByKeyWithNonExistingVersion() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        try {
            this.decisionService.evaluateDecisionTableByKeyAndVersion(decisionDefinition.getKey(), Integer.valueOf(42), null);
            DecisionServiceTest.fail((String)"expect exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("no decision definition deployed with key = 'decision' and version = '42'", e.getMessage());
        }
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    protected void assertThatDecisionHasResult(DmnDecisionTableResult decisionResult, Object expectedValue) {
        Assert.assertThat((Object)decisionResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)decisionResult.size(), (Matcher)CoreMatchers.is((Object)1));
        String value = (String)decisionResult.getSingleResult().getFirstEntry();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)expectedValue));
    }
}

