/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.util.CustomSerializable;
import org.camunda.bpm.engine.test.api.runtime.util.FailingSerializable;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Test;

public class VariableInstanceQueryTest
extends PluggableProcessEngineTestCase {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQuery() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intVar", 123);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        VariableInstanceQueryTest.assertNotNull((Object)query);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertNotNull((Object)var.getId());
            if (var.getName().equals("intVar")) {
                VariableInstanceQueryTest.assertEquals((String)"intVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    public void testQueryByVariableId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "test");
        variables.put("var2", "test");
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstance result = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)result);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableId(result.getId());
        VariableInstanceQueryTest.assertNotNull((Object)query);
        VariableInstance resultById = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertEquals((String)result.getId(), (String)resultById.getId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableName() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("stringVar");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableNames() {
        String variableValue = "a";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("process", variableValue);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "task", (Object)variableValue);
        this.runtimeService.setVariableLocal(task.getExecutionId(), "execution", (Object)variableValue);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableNameIn(new String[]{"task", "process", "execution"});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance variableInstance : result) {
            VariableInstanceQueryTest.assertEquals((Object)variableValue, (Object)variableInstance.getValue());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)variableInstance.getTypeName());
        }
        VariableInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("task").variableNameIn(new String[]{"task", "execution"}).count());
        VariableInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("task").variableNameIn(new String[]{"process", "execution"}).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableNameLike() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableNameLike("%ingV%");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableNameLikeWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableNameLike("%ingV_");
        List result = query.list();
        VariableInstanceQueryTest.assertTrue((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_String() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("stringVar", (Object)"test");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test123");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("stringVar", (Object)"test123");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueGreaterThan_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("stringVar", (Object)"a");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getValue().equals("b")) {
                VariableInstanceQueryTest.assertEquals((Object)"b", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("c")) {
                VariableInstanceQueryTest.assertEquals((Object)"c", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueGreaterThanOrEqual_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"a");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getValue().equals("a")) {
                VariableInstanceQueryTest.assertEquals((Object)"a", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("b")) {
                VariableInstanceQueryTest.assertEquals((Object)"b", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("c")) {
                VariableInstanceQueryTest.assertEquals((Object)"c", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueLessThan_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("stringVar", (Object)"c");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getValue().equals("a")) {
                VariableInstanceQueryTest.assertEquals((Object)"a", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("b")) {
                VariableInstanceQueryTest.assertEquals((Object)"b", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueLessThanOrEqual_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"c");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getValue().equals("a")) {
                VariableInstanceQueryTest.assertEquals((Object)"a", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("b")) {
                VariableInstanceQueryTest.assertEquals((Object)"b", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("c")) {
                VariableInstanceQueryTest.assertEquals((Object)"c", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueLike_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test123");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test456");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "test789");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLike("stringVar", "test%");
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getValue().equals("test123")) {
                VariableInstanceQueryTest.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("test456")) {
                VariableInstanceQueryTest.assertEquals((Object)"test456", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("test789")) {
                VariableInstanceQueryTest.assertEquals((Object)"test789", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Integer() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("intValue", (Object)1234);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"intValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)1234, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"integer", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("intValue", (Object)5555);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"intValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)1234, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"integer", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("intValue", (Object)1234);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"intValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)var.getTypeName());
            if (var.getValue().equals(5555)) {
                VariableInstanceQueryTest.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(9876)) {
                VariableInstanceQueryTest.assertEquals((Object)9876, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("intValue", (Object)1234);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"intValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)var.getTypeName());
            if (var.getValue().equals(1234)) {
                VariableInstanceQueryTest.assertEquals((Object)1234, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(5555)) {
                VariableInstanceQueryTest.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(9876)) {
                VariableInstanceQueryTest.assertEquals((Object)9876, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("intValue", (Object)9876);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"intValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)var.getTypeName());
            if (var.getValue().equals(5555)) {
                VariableInstanceQueryTest.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(1234)) {
                VariableInstanceQueryTest.assertEquals((Object)1234, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("intValue", (Object)9876);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"intValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)var.getTypeName());
            if (var.getValue().equals(1234)) {
                VariableInstanceQueryTest.assertEquals((Object)1234, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(5555)) {
                VariableInstanceQueryTest.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(9876)) {
                VariableInstanceQueryTest.assertEquals((Object)9876, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Long() {
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("longValue", (Object)123456L);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"longValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)123456L, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"long", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("longValue", (Object)987654L);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"longValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)123456L, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"long", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("longValue", (Object)123456L);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"longValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"long", (String)var.getTypeName());
            if (var.getValue().equals(555555L)) {
                VariableInstanceQueryTest.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(987654L)) {
                VariableInstanceQueryTest.assertEquals((Object)987654L, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("longValue", (Object)123456L);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"longValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"long", (String)var.getTypeName());
            if (var.getValue().equals(123456L)) {
                VariableInstanceQueryTest.assertEquals((Object)123456L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(555555L)) {
                VariableInstanceQueryTest.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(987654L)) {
                VariableInstanceQueryTest.assertEquals((Object)987654L, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("longValue", (Object)987654L);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"longValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"long", (String)var.getTypeName());
            if (var.getValue().equals(123456L)) {
                VariableInstanceQueryTest.assertEquals((Object)123456L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(555555L)) {
                VariableInstanceQueryTest.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("longValue", (Object)987654L);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"longValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"long", (String)var.getTypeName());
            if (var.getValue().equals(123456L)) {
                VariableInstanceQueryTest.assertEquals((Object)123456L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(555555L)) {
                VariableInstanceQueryTest.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(987654L)) {
                VariableInstanceQueryTest.assertEquals((Object)987654L, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Double() {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("doubleValue", (Object)123.456);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"doubleValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)123.456, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"double", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("doubleValue", (Object)654.321);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"doubleValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)123.456, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"double", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("doubleValue", (Object)123.456);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"doubleValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"double", (String)var.getTypeName());
            if (var.getValue().equals(654.321)) {
                VariableInstanceQueryTest.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(999.999)) {
                VariableInstanceQueryTest.assertEquals((Object)999.999, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("doubleValue", (Object)123.456);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"doubleValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"double", (String)var.getTypeName());
            if (var.getValue().equals(123.456)) {
                VariableInstanceQueryTest.assertEquals((Object)123.456, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(654.321)) {
                VariableInstanceQueryTest.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(999.999)) {
                VariableInstanceQueryTest.assertEquals((Object)999.999, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("doubleValue", (Object)999.999);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"doubleValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"double", (String)var.getTypeName());
            if (var.getValue().equals(123.456)) {
                VariableInstanceQueryTest.assertEquals((Object)123.456, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(654.321)) {
                VariableInstanceQueryTest.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("doubleValue", (Object)999.999);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"doubleValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"double", (String)var.getTypeName());
            if (var.getValue().equals(123.456)) {
                VariableInstanceQueryTest.assertEquals((Object)123.456, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(654.321)) {
                VariableInstanceQueryTest.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(999.999)) {
                VariableInstanceQueryTest.assertEquals((Object)999.999, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Short() {
        HashMap<String, Short> variables = new HashMap<String, Short>();
        variables.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("shortValue", (Object)123);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"shortValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)123, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"short", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableValueNotEquals_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("shortValue", (Object)999);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"shortValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)123, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"short", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("shortValue", (Object)123);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"shortValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"short", (String)var.getTypeName());
            if (var.getValue().equals((short)555)) {
                VariableInstanceQueryTest.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)999)) {
                VariableInstanceQueryTest.assertEquals((Object)999, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("shortValue", (Object)123);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"shortValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"short", (String)var.getTypeName());
            if (var.getValue().equals((short)123)) {
                VariableInstanceQueryTest.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)555)) {
                VariableInstanceQueryTest.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)999)) {
                VariableInstanceQueryTest.assertEquals((Object)999, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("shortValue", (Object)999);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"shortValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"short", (String)var.getTypeName());
            if (var.getValue().equals((short)123)) {
                VariableInstanceQueryTest.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)555)) {
                VariableInstanceQueryTest.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("shortValue", (Object)999);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"shortValue", (String)var.getName());
            VariableInstanceQueryTest.assertEquals((String)"short", (String)var.getTypeName());
            if (var.getValue().equals((short)123)) {
                VariableInstanceQueryTest.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)555)) {
                VariableInstanceQueryTest.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)999)) {
                VariableInstanceQueryTest.assertEquals((Object)999, (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Bytes() {
        byte[] bytes = "somebytes".getBytes();
        HashMap<String, byte[]> variables = new HashMap<String, byte[]>();
        variables.put("bytesVar", bytes);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("bytesVar", (Object)bytes);
        try {
            query.list();
            VariableInstanceQueryTest.fail((String)"A ProcessEngineException was expected: Variables of type ByteArray cannot be used to query.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Date() {
        Date now = new Date();
        HashMap<String, Date> variables = new HashMap<String, Date>();
        variables.put("date", now);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("date", (Object)now);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"date", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)now, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"date", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEqualsWihtoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("stringVar", (Object)"notFoundValue");
        List result = query.list();
        VariableInstanceQueryTest.assertTrue((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_NullValue() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("nullValue", null);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("nullValue", null);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"nullValue", (String)var.getName());
        VariableInstanceQueryTest.assertEquals(null, (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"null", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableValueNotEquals_NullValue() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("value", null);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("value", (short)999);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("value", "abc");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("value", null);
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"value", (String)var.getName());
            if (var.getValue().equals((short)999)) {
                VariableInstanceQueryTest.assertEquals((Object)999, (Object)var.getValue());
                VariableInstanceQueryTest.assertEquals((String)"short", (String)var.getTypeName());
                continue;
            }
            if (var.getValue().equals("abc")) {
                VariableInstanceQueryTest.assertEquals((Object)"abc", (Object)var.getValue());
                VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getName().equals("myVar")) {
                VariableInstanceQueryTest.assertEquals((String)"myVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceIds() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getName().equals("myVar")) {
                VariableInstanceQueryTest.assertEquals((String)"myVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceIdWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{"aProcessInstanceId"});
        List result = query.list();
        VariableInstanceQueryTest.assertTrue((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().executionIdIn(new String[]{processInstance.getId()});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getName().equals("myVar")) {
                VariableInstanceQueryTest.assertEquals((String)"myVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)3, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getName().equals("myVar")) {
                VariableInstanceQueryTest.assertEquals((String)"myVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionIdWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().executionIdIn(new String[]{"anExecutionId"});
        List result = query.list();
        VariableInstanceQueryTest.assertTrue((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByTaskId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"aCustomValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{task.getId()});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"taskVariable", (String)var.getName());
        VariableInstanceQueryTest.assertEquals((Object)"aCustomValue", (Object)var.getValue());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByTaskIds() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).singleResult();
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance3.getId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.setVariableLocal(task2.getId(), "anotherTaskVariable", (Object)"aCustomValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{task1.getId(), task2.getId(), task3.getId()});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getName().equals("taskVariable")) {
                VariableInstanceQueryTest.assertEquals((String)"taskVariable", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("anotherTaskVariable")) {
                VariableInstanceQueryTest.assertEquals((String)"anotherTaskVariable", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByTaskIdWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"aCustomValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{"aTaskId"});
        List result = query.list();
        VariableInstanceQueryTest.assertTrue((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/VariableInstanceQueryTest.taskInEmbeddedSubProcess.bpmn20.xml"})
    public void testQueryByVariableScopeId() {
        List variableInstances;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)task);
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        String processInstanceId = task.getProcessInstanceId();
        String variableName = "foo";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(taskId, "task");
        variables.put(executionId, "execution");
        variables.put(processInstanceId, "processInstance");
        this.taskService.setVariableLocal(taskId, variableName, variables.get(taskId));
        this.runtimeService.setVariableLocal(executionId, variableName, variables.get(executionId));
        this.runtimeService.setVariableLocal(processInstanceId, variableName, variables.get(processInstanceId));
        for (String variableScopeId : variables.keySet()) {
            variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{variableScopeId}).list();
            VariableInstanceQueryTest.assertEquals((int)1, (int)variableInstances.size());
            VariableInstanceQueryTest.assertEquals((String)variableName, (String)((VariableInstance)variableInstances.get(0)).getName());
            VariableInstanceQueryTest.assertEquals(variables.get(variableScopeId), (Object)((VariableInstance)variableInstances.get(0)).getValue());
        }
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        VariableInstanceQueryTest.assertEquals((int)3, (int)variableInstances.size());
        this.taskService.removeVariableLocal(taskId, variableName);
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId}).list();
        VariableInstanceQueryTest.assertEquals((int)0, (int)variableInstances.size());
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        VariableInstanceQueryTest.assertEquals((int)2, (int)variableInstances.size());
        this.runtimeService.removeVariable(processInstanceId, variableName);
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{processInstanceId, taskId}).list();
        VariableInstanceQueryTest.assertEquals((int)0, (int)variableInstances.size());
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        VariableInstanceQueryTest.assertEquals((int)1, (int)variableInstances.size());
        this.runtimeService.removeVariable(executionId, variableName);
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        VariableInstanceQueryTest.assertEquals((int)0, (int)variableInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByActivityInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ExecutionEntity execution = (ExecutionEntity)processInstance;
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"aCustomValue");
        VariableInstanceQuery taskVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{execution.getActivityInstanceId()});
        VariableInstanceQuery processVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{execution.getProcessInstanceId()});
        VariableInstance taskVar = (VariableInstance)taskVariablesQuery.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)taskVar);
        VariableInstanceQueryTest.assertEquals((long)1L, (long)taskVariablesQuery.count());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)taskVar.getTypeName());
        VariableInstanceQueryTest.assertEquals((String)"taskVariable", (String)taskVar.getName());
        VariableInstanceQueryTest.assertEquals((Object)"aCustomValue", (Object)taskVar.getValue());
        VariableInstance processVar = (VariableInstance)processVariablesQuery.singleResult();
        VariableInstanceQueryTest.assertEquals((long)1L, (long)processVariablesQuery.count());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)processVar.getTypeName());
        VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)processVar.getName());
        VariableInstanceQueryTest.assertEquals((Object)"test", (Object)processVar.getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByActivityInstanceIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ExecutionEntity execution1 = (ExecutionEntity)this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ExecutionEntity execution2 = (ExecutionEntity)this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("myVar", "test123");
        ExecutionEntity execution3 = (ExecutionEntity)this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables3);
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(execution1.getProcessInstanceId()).singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(execution2.getProcessInstanceId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.setVariableLocal(task2.getId(), "anotherTaskVariable", (Object)"aCustomValue");
        VariableInstanceQuery processVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{execution1.getProcessInstanceId(), execution2.getProcessInstanceId(), execution3.getProcessInstanceId()});
        VariableInstanceQuery taskVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{execution1.getActivityInstanceId(), execution2.getActivityInstanceId()});
        List result = processVariablesQuery.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)4, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)4L, (long)processVariablesQuery.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getName().equals("myVar")) {
                VariableInstanceQueryTest.assertEquals((String)"myVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
        result = taskVariablesQuery.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstanceQueryTest.assertEquals((long)2L, (long)taskVariablesQuery.count());
        for (VariableInstance var : result) {
            VariableInstanceQueryTest.assertEquals((String)"string", (String)var.getTypeName());
            if (var.getName().equals("taskVariable")) {
                VariableInstanceQueryTest.assertEquals((String)"taskVariable", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("anotherTaskVariable")) {
                VariableInstanceQueryTest.assertEquals((String)"anotherTaskVariable", (String)var.getName());
                VariableInstanceQueryTest.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByName_Asc() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().asc();
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        VariableInstanceQueryTest.assertEquals((String)"myVar", (String)first.getName());
        VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)second.getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByName_Desc() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().desc();
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)first.getName());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)first.getTypeName());
        VariableInstanceQueryTest.assertEquals((String)"myVar", (String)second.getName());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)second.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByType_Asc() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("intVar", 123);
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableType().asc();
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        VariableInstanceQueryTest.assertEquals((String)"intVar", (String)first.getName());
        VariableInstanceQueryTest.assertEquals((String)"integer", (String)first.getTypeName());
        VariableInstanceQueryTest.assertEquals((String)"myVar", (String)second.getName());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)second.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByType_Desc() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("intVar", 123);
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableType().desc();
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        VariableInstanceQueryTest.assertEquals((String)"myVar", (String)first.getName());
        VariableInstanceQueryTest.assertEquals((String)"string", (String)first.getTypeName());
        VariableInstanceQueryTest.assertEquals((String)"intVar", (String)second.getName());
        VariableInstanceQueryTest.assertEquals((String)"integer", (String)second.getTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByActivityInstanceId_Asc() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intVar", 123);
        ExecutionEntity execution1 = (ExecutionEntity)this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test");
        ExecutionEntity execution2 = (ExecutionEntity)this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        int comparisonResult = execution1.getActivityInstanceId().compareTo(execution2.getActivityInstanceId());
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByActivityInstanceId().asc();
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        if (comparisonResult < 0) {
            VariableInstanceQueryTest.assertEquals((String)"intVar", (String)first.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)first.getTypeName());
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)second.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)second.getTypeName());
        } else if (comparisonResult > 0) {
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)first.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)first.getTypeName());
            VariableInstanceQueryTest.assertEquals((String)"intVar", (String)second.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)second.getTypeName());
        } else {
            VariableInstanceQueryTest.fail((String)("Something went wrong: both activity instances have the same id " + execution1.getActivityInstanceId() + " and " + execution2.getActivityInstanceId()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByActivityInstanceId_Desc() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intVar", 123);
        ExecutionEntity execution1 = (ExecutionEntity)this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test");
        ExecutionEntity execution2 = (ExecutionEntity)this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        int comparisonResult = execution1.getActivityInstanceId().compareTo(execution2.getActivityInstanceId());
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByActivityInstanceId().desc();
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        if (comparisonResult < 0) {
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)first.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)first.getTypeName());
            VariableInstanceQueryTest.assertEquals((String)"intVar", (String)second.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)second.getTypeName());
        } else if (comparisonResult > 0) {
            VariableInstanceQueryTest.assertEquals((String)"intVar", (String)first.getName());
            VariableInstanceQueryTest.assertEquals((String)"integer", (String)first.getTypeName());
            VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)second.getName());
            VariableInstanceQueryTest.assertEquals((String)"string", (String)second.getTypeName());
        } else {
            VariableInstanceQueryTest.fail((String)("Something went wrong: both activity instances have the same id " + execution1.getActivityInstanceId() + " and " + execution2.getActivityInstanceId()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void FAILING_testGetValueOfSerializableVar() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        HashMap<String, ArrayList<String>> variables = new HashMap<String, ArrayList<String>>();
        variables.put("serializableVar", serializable);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()});
        List result = query.list();
        VariableInstanceQueryTest.assertFalse((boolean)result.isEmpty());
        VariableInstanceQueryTest.assertEquals((int)1, (int)result.size());
        VariableInstance instance = (VariableInstance)result.get(0);
        VariableInstanceQueryTest.assertEquals((String)"serializableVar", (String)instance.getName());
        VariableInstanceQueryTest.assertNotNull((Object)instance.getValue());
        VariableInstanceQueryTest.assertEquals(serializable, (Object)instance.getValue());
        VariableInstanceQueryTest.assertEquals((String)"Serializable", (String)instance.getTypeName());
    }

    @Test
    @Deployment
    public void testSubProcessVariablesWithParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processWithSubProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        VariableInstanceQueryTest.assertNotNull((Object)tree);
        ActivityInstance[] subprocessInstances = tree.getActivityInstances("SubProcess_1");
        VariableInstanceQueryTest.assertEquals((int)5, (int)subprocessInstances.length);
        String activityInstanceId1 = subprocessInstances[0].getId();
        VariableInstanceQuery query1 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId1});
        String activityInstanceId2 = subprocessInstances[1].getId();
        VariableInstanceQuery query2 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId2});
        String activityInstanceId3 = subprocessInstances[2].getId();
        VariableInstanceQuery query3 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId3});
        String activityInstanceId4 = subprocessInstances[3].getId();
        VariableInstanceQuery query4 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId4});
        String activityInstanceId5 = subprocessInstances[4].getId();
        VariableInstanceQuery query5 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId5});
        this.checkVariables(query1.list());
        this.checkVariables(query2.list());
        this.checkVariables(query3.list());
        this.checkVariables(query4.list());
        this.checkVariables(query5.list());
    }

    private void checkVariables(List<VariableInstance> variableInstances) {
        VariableInstanceQueryTest.assertFalse((boolean)variableInstances.isEmpty());
        for (VariableInstance instance : variableInstances) {
            if (instance.getName().equals("nrOfInstances")) {
                VariableInstanceQueryTest.assertEquals((String)"nrOfInstances", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"integer", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("nrOfCompletedInstances")) {
                VariableInstanceQueryTest.assertEquals((String)"nrOfCompletedInstances", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"integer", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("nrOfActiveInstances")) {
                VariableInstanceQueryTest.assertEquals((String)"nrOfActiveInstances", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"integer", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("loopCounter")) {
                VariableInstanceQueryTest.assertEquals((String)"loopCounter", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"integer", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("nullVar")) {
                VariableInstanceQueryTest.assertEquals((String)"nullVar", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"null", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("integerVar")) {
                VariableInstanceQueryTest.assertEquals((String)"integerVar", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"integer", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("dateVar")) {
                VariableInstanceQueryTest.assertEquals((String)"dateVar", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"date", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("stringVar")) {
                VariableInstanceQueryTest.assertEquals((String)"stringVar", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"string", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("shortVar")) {
                VariableInstanceQueryTest.assertEquals((String)"shortVar", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"short", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("longVar")) {
                VariableInstanceQueryTest.assertEquals((String)"longVar", (String)instance.getName());
                VariableInstanceQueryTest.assertEquals((String)"long", (String)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("serializableVar")) {
                VariableInstanceQueryTest.assertEquals((String)"serializableVar", (String)instance.getName());
                try {
                    instance.getValue();
                }
                catch (NullPointerException e) {}
                continue;
            }
            VariableInstanceQueryTest.fail((String)("An unexpected variable '" + instance.getName() + "' was found with value " + instance.getValue()));
        }
    }

    @Test
    @Deployment
    public void testSubProcessVariables() {
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("processVariable", "aProcessVariable");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processWithSubProcess", processVariables);
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        VariableInstanceQueryTest.assertNotNull((Object)tree);
        VariableInstanceQueryTest.assertEquals((int)1, (int)tree.getChildActivityInstances().length);
        VariableInstanceQuery query1 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{tree.getId()});
        VariableInstance processVariable = (VariableInstance)query1.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)processVariable);
        VariableInstanceQueryTest.assertEquals((String)"processVariable", (String)processVariable.getName());
        VariableInstanceQueryTest.assertEquals((Object)"aProcessVariable", (Object)processVariable.getValue());
        ActivityInstance subProcessActivityInstance = tree.getActivityInstances("SubProcess_1")[0];
        VariableInstanceQuery query2 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{subProcessActivityInstance.getId()});
        this.checkVariables(query2.list());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"taskVariableValue");
        ActivityInstance taskActivityInstance = subProcessActivityInstance.getChildActivityInstances()[0];
        VariableInstanceQuery query3 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{taskActivityInstance.getId()});
        List variables = query3.list();
        VariableInstance taskVariable = (VariableInstance)query3.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)taskVariable);
        VariableInstanceQueryTest.assertEquals((String)"taskVariable", (String)taskVariable.getName());
        VariableInstanceQueryTest.assertEquals((Object)"taskVariableValue", (Object)taskVariable.getValue());
    }

    @Test
    @Deployment
    public void testParallelGatewayVariables() {
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("processVariable", "aProcessVariable");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGatewayProcess", processVariables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(execution.getId(), "aLocalVariable", (Object)"aLocalValue");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        VariableInstanceQueryTest.assertEquals((int)2, (int)tree.getChildActivityInstances().length);
        ActivityInstance task1Instance = tree.getActivityInstances("task1")[0];
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aLocalVariable").activityInstanceIdIn(new String[]{task1Instance.getId()});
        VariableInstance localVariable = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)localVariable);
        VariableInstanceQueryTest.assertEquals((String)"aLocalVariable", (String)localVariable.getName());
        VariableInstanceQueryTest.assertEquals((Object)"aLocalValue", (Object)localVariable.getValue());
        Task task = (Task)this.taskService.createTaskQuery().executionId(execution.getId()).singleResult();
        this.taskService.complete(task.getId());
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        VariableInstanceQueryTest.assertEquals((int)2, (int)tree.getChildActivityInstances().length);
        ActivityInstance task3Instance = tree.getActivityInstances("task3")[0];
        query = this.runtimeService.createVariableInstanceQuery().variableName("aLocalVariable").activityInstanceIdIn(new String[]{task3Instance.getId()});
        localVariable = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)localVariable);
        VariableInstanceQueryTest.assertEquals((String)"aLocalVariable", (String)localVariable.getName());
        VariableInstanceQueryTest.assertEquals((Object)"aLocalValue", (Object)localVariable.getValue());
    }

    @Deployment
    public void testSimpleSubProcessVariables() {
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("processVariable", "aProcessVariable");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processWithSubProcess", processVariables);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("UserTask_1").singleResult();
        this.runtimeService.setVariableLocal(task.getExecutionId(), "aLocalVariable", (Object)"aLocalValue");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        VariableInstanceQueryTest.assertEquals((int)1, (int)tree.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = tree.getActivityInstances("SubProcess_1")[0];
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{subProcessInstance.getId()});
        VariableInstance localVariable = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)localVariable);
        VariableInstanceQueryTest.assertEquals((String)"aLocalVariable", (String)localVariable.getName());
        VariableInstanceQueryTest.assertEquals((Object)"aLocalValue", (Object)localVariable.getValue());
        query = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{processInstance.getId()});
        VariableInstance globalVariable = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)localVariable);
        VariableInstanceQueryTest.assertEquals((String)"processVariable", (String)globalVariable.getName());
        VariableInstanceQueryTest.assertEquals((Object)"aProcessVariable", (Object)globalVariable.getValue());
        this.taskService.complete(task.getId());
    }

    @Test
    public void testDisableBinaryFetching() {
        byte[] binaryContent = "some binary content".getBytes();
        HashMap<String, byte[]> variables = new HashMap<String, byte[]>();
        variables.put("binaryVariable", binaryContent);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        VariableInstance result = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)result.getValue());
        query = this.runtimeService.createVariableInstanceQuery().disableBinaryFetching();
        result = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNull((Object)result.getValue());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDisableBinaryFetchingForFileValues() {
        String fileName = "text.txt";
        String encoding = "crazy-encoding";
        String mimeType = "martini/dry";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file("ABC".getBytes()).encoding(encoding).mimeType(mimeType).create();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        VariableInstance fileVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)fileVariableInstance.getValue());
        fileVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().disableBinaryFetching().singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)fileVariableInstance);
        VariableInstanceQueryTest.assertEquals((String)"fileVar", (String)fileVariableInstance.getName());
        VariableInstanceQueryTest.assertNull((Object)fileVariableInstance.getValue());
        FileValue typedValue = (FileValue)fileVariableInstance.getTypedValue();
        VariableInstanceQueryTest.assertNull((Object)typedValue.getValue());
        VariableInstanceQueryTest.assertEquals((Object)ValueType.FILE, (Object)typedValue.getType());
        VariableInstanceQueryTest.assertEquals((String)fileName, (String)typedValue.getFilename());
        VariableInstanceQueryTest.assertEquals((String)encoding, (String)typedValue.getEncoding());
        VariableInstanceQueryTest.assertEquals((String)mimeType, (String)typedValue.getMimeType());
    }

    @Test
    public void testDisableCustomObjectDeserialization() {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().disableCustomObjectDeserialization();
        List results = query.list();
        VariableInstanceQueryTest.assertEquals((int)2, (int)results.size());
        for (VariableInstance variableInstance : results) {
            VariableInstanceQueryTest.assertNull((Object)variableInstance.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableInstance.getTypedValue();
            VariableInstanceQueryTest.assertNotNull((Object)typedValue);
            VariableInstanceQueryTest.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            VariableInstanceQueryTest.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testSerializableErrorMessage() {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List results = query.list();
        VariableInstanceQueryTest.assertEquals((int)2, (int)results.size());
        for (VariableInstance variableInstance : results) {
            if (variableInstance.getName().equals("customSerializable")) {
                VariableInstanceQueryTest.assertNotNull((Object)variableInstance.getValue());
                VariableInstanceQueryTest.assertTrue((boolean)(variableInstance.getValue() instanceof CustomSerializable));
            }
            if (!variableInstance.getName().equals("failingSerializable")) continue;
            VariableInstanceQueryTest.assertNull((Object)variableInstance.getValue());
            VariableInstanceQueryTest.assertNotNull((Object)variableInstance.getErrorMessage());
        }
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        CaseInstance instance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseExecutionIdIn(new String[]{instance.getId()});
        VariableInstance result = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)result);
        VariableInstanceQueryTest.assertEquals((String)"aVariableName", (String)result.getName());
        VariableInstanceQueryTest.assertEquals((Object)"abc", (Object)result.getValue());
        VariableInstanceQueryTest.assertEquals((String)instance.getId(), (String)result.getCaseExecutionId());
        VariableInstanceQueryTest.assertEquals((String)instance.getId(), (String)result.getCaseInstanceId());
        VariableInstanceQueryTest.assertNull((Object)result.getExecutionId());
        VariableInstanceQueryTest.assertNull((Object)result.getProcessInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionIds() {
        CaseInstance instance1 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        CaseInstance instance2 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("anotherVariableName", (Object)"xyz").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseExecutionIdIn(new String[]{instance1.getId(), instance2.getId()}).orderByVariableName().asc();
        List result = query.list();
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                VariableInstanceQueryTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                VariableInstanceQueryTest.assertEquals((Object)"abc", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                VariableInstanceQueryTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                VariableInstanceQueryTest.assertEquals((Object)"xyz", (Object)variableInstance.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        CaseInstance instance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseInstanceIdIn(new String[]{instance.getId()});
        VariableInstance result = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)result);
        VariableInstanceQueryTest.assertEquals((String)"aVariableName", (String)result.getName());
        VariableInstanceQueryTest.assertEquals((Object)"abc", (Object)result.getValue());
        VariableInstanceQueryTest.assertEquals((String)instance.getId(), (String)result.getCaseExecutionId());
        VariableInstanceQueryTest.assertEquals((String)instance.getId(), (String)result.getCaseInstanceId());
        VariableInstanceQueryTest.assertNull((Object)result.getExecutionId());
        VariableInstanceQueryTest.assertNull((Object)result.getProcessInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceIds() {
        CaseInstance instance1 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        CaseInstance instance2 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("anotherVariableName", (Object)"xyz").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseInstanceIdIn(new String[]{instance1.getId(), instance2.getId()}).orderByVariableName().asc();
        List result = query.list();
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                VariableInstanceQueryTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                VariableInstanceQueryTest.assertEquals((Object)"abc", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                VariableInstanceQueryTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                VariableInstanceQueryTest.assertEquals((Object)"xyz", (Object)variableInstance.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseActivityInstanceId() {
        CaseInstance instance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{instance.getId()});
        VariableInstance result = (VariableInstance)query.singleResult();
        VariableInstanceQueryTest.assertNotNull((Object)result);
        VariableInstanceQueryTest.assertEquals((String)"aVariableName", (String)result.getName());
        VariableInstanceQueryTest.assertEquals((Object)"abc", (Object)result.getValue());
        VariableInstanceQueryTest.assertEquals((String)instance.getId(), (String)result.getCaseExecutionId());
        VariableInstanceQueryTest.assertEquals((String)instance.getId(), (String)result.getCaseInstanceId());
        VariableInstanceQueryTest.assertNull((Object)result.getExecutionId());
        VariableInstanceQueryTest.assertNull((Object)result.getProcessInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseActivityInstanceIds() {
        CaseInstance instance1 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        CaseInstance instance2 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("anotherVariableName", (Object)"xyz").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{instance1.getId(), instance2.getId()}).orderByVariableName().asc();
        List result = query.list();
        VariableInstanceQueryTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                VariableInstanceQueryTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                VariableInstanceQueryTest.assertEquals((Object)"abc", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                VariableInstanceQueryTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                VariableInstanceQueryTest.assertEquals((Object)"xyz", (Object)variableInstance.getValue());
                continue;
            }
            VariableInstanceQueryTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment
    public void testSequentialMultiInstanceSubProcess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        VariableInstance nrOfInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfInstances").singleResult();
        VariableInstance nrOfActiveInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfActiveInstances").singleResult();
        VariableInstance nrOfCompletedInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfCompletedInstances").singleResult();
        VariableInstance loopCounter = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("loopCounter").singleResult();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        VariableInstanceQueryTest.assertEquals((String)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (String)nrOfInstances.getActivityInstanceId());
        VariableInstanceQueryTest.assertEquals((String)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (String)nrOfActiveInstances.getActivityInstanceId());
        VariableInstanceQueryTest.assertEquals((String)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (String)nrOfCompletedInstances.getActivityInstanceId());
        VariableInstanceQueryTest.assertEquals((String)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (String)loopCounter.getActivityInstanceId());
    }

    @Deployment
    public void testParallelMultiInstanceSubProcess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        VariableInstance nrOfInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfInstances").singleResult();
        VariableInstance nrOfActiveInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfActiveInstances").singleResult();
        VariableInstance nrOfCompletedInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfCompletedInstances").singleResult();
        List loopCounters = this.runtimeService.createVariableInstanceQuery().variableName("loopCounter").list();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        VariableInstanceQueryTest.assertEquals((String)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (String)nrOfInstances.getActivityInstanceId());
        VariableInstanceQueryTest.assertEquals((String)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (String)nrOfActiveInstances.getActivityInstanceId());
        VariableInstanceQueryTest.assertEquals((String)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (String)nrOfCompletedInstances.getActivityInstanceId());
        HashSet<String> loopCounterActivityInstanceIds = new HashSet<String>();
        for (VariableInstance loopCounter : loopCounters) {
            loopCounterActivityInstanceIds.add(loopCounter.getActivityInstanceId());
        }
        VariableInstanceQueryTest.assertEquals((int)4, (int)loopCounterActivityInstanceIds.size());
        for (ActivityInstance subProcessInstance : tree.getActivityInstances("miSubProcess")) {
            VariableInstanceQueryTest.assertTrue((boolean)loopCounterActivityInstanceIds.contains(subProcessInstance.getId()));
        }
    }
}

