/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class ExecutionAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_BOUNDARY_PROCESS_KEY = "messageBoundaryProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/messageBoundaryEventProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 1);
        Execution execution = (Execution)query.singleResult();
        ExecutionAuthorizationTest.assertNotNull((Object)execution);
        ExecutionAuthorizationTest.assertEquals((String)processInstanceId, (String)execution.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 1);
        Execution execution = (Execution)query.singleResult();
        ExecutionAuthorizationTest.assertNotNull((Object)execution);
        ExecutionAuthorizationTest.assertEquals((String)processInstanceId, (String)execution.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 1);
        Execution execution = (Execution)query.singleResult();
        ExecutionAuthorizationTest.assertNotNull((Object)execution);
        ExecutionAuthorizationTest.assertEquals((String)processInstanceId, (String)execution.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 1);
        Execution execution = (Execution)query.singleResult();
        ExecutionAuthorizationTest.assertNotNull((Object)execution);
        ExecutionAuthorizationTest.assertEquals((String)processInstanceId, (String)execution.getProcessInstanceId());
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 1);
        Execution execution = (Execution)query.singleResult();
        ExecutionAuthorizationTest.assertNotNull((Object)execution);
        ExecutionAuthorizationTest.assertEquals((String)processInstanceId, (String)execution.getProcessInstanceId());
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 11);
    }

    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults(query, 11);
    }

    protected void verifyQueryResults(ExecutionQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

