/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.externaltask;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class FetchExternalTaskAuthorizationTest
extends AuthorizationTest {
    public static final String WORKER_ID = "workerId";
    public static final long LOCK_TIME = 10000L;
    protected String deploymentId;
    protected String instance1Id;
    protected String instance2Id;

    @Override
    protected void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml").getId();
        this.instance1Id = this.startProcessInstanceByKey("oneExternalTaskProcess").getId();
        this.instance2Id = this.startProcessInstanceByKey("twoExternalTaskProcess").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testFetchWithoutAuthorization() {
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testFetchWithReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testFetchWithUpdateOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testFetchWithReadAndUpdateOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ, Permissions.UPDATE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)1, (int)tasks.size());
        FetchExternalTaskAuthorizationTest.assertEquals((String)this.instance1Id, (String)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    public void testFetchWithReadInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testFetchWithUpdateInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testFetchWithReadAndUpdateInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)1, (int)tasks.size());
        FetchExternalTaskAuthorizationTest.assertEquals((String)this.instance1Id, (String)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    public void testFetchWithReadOnProcessInstanceAndUpdateInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)1, (int)tasks.size());
        FetchExternalTaskAuthorizationTest.assertEquals((String)this.instance1Id, (String)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    public void testFetchWithUpdateOnProcessInstanceAndReadInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)1, (int)tasks.size());
        FetchExternalTaskAuthorizationTest.assertEquals((String)this.instance1Id, (String)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    public void testFetchWithReadAndUpdateOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ, Permissions.UPDATE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testQueryWithReadAndUpdateInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testQueryWithReadProcessInstanceAndUpdateInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        FetchExternalTaskAuthorizationTest.assertEquals((int)1, (int)tasks.size());
        FetchExternalTaskAuthorizationTest.assertEquals((String)this.instance1Id, (String)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }
}

