/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationExceptionInterceptor;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationScenarioInstance;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class AuthorizationTestRule
extends TestWatcher {
    protected ProcessEngineRule engineRule;
    protected AuthorizationExceptionInterceptor interceptor;
    protected CommandExecutor replacedCommandExecutor;
    protected AuthorizationScenarioInstance scenarioInstance;
    protected List<User> users = new ArrayList<User>();
    protected List<Group> groups = new ArrayList<Group>();

    public AuthorizationTestRule(ProcessEngineRule engineRule) {
        this.engineRule = engineRule;
        this.interceptor = new AuthorizationExceptionInterceptor();
    }

    public void start(AuthorizationScenario scenario) {
        this.start(scenario, null, new HashMap<String, String>());
    }

    public void start(AuthorizationScenario scenario, String userId, Map<String, String> resourceBindings) {
        Assert.assertNull((Object)((Object)this.interceptor.getLastException()));
        this.scenarioInstance = new AuthorizationScenarioInstance(scenario, this.engineRule.getAuthorizationService(), resourceBindings);
        this.enableAuthorization(userId);
        this.interceptor.activate();
    }

    public void enableAuthorization(String userId) {
        this.engineRule.getProcessEngine().getProcessEngineConfiguration().setAuthorizationEnabled(true);
        if (userId != null) {
            this.engineRule.getIdentityService().setAuthenticatedUserId(userId);
        }
    }

    public boolean assertScenario(AuthorizationScenario scenario) {
        this.interceptor.deactivate();
        this.disableAuthorization();
        this.scenarioInstance.tearDown(this.engineRule.getAuthorizationService());
        this.scenarioInstance.assertAuthorizationException(this.interceptor.getLastException());
        this.scenarioInstance = null;
        return this.scenarioSucceeded();
    }

    public boolean scenarioSucceeded() {
        return this.interceptor.getLastException() == null;
    }

    public boolean scenarioFailed() {
        return this.interceptor.getLastException() != null;
    }

    public void disableAuthorization() {
        this.engineRule.getProcessEngine().getProcessEngineConfiguration().setAuthorizationEnabled(false);
        this.engineRule.getIdentityService().clearAuthentication();
    }

    protected void starting(Description description) {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        this.interceptor.reset();
        ((CommandInterceptor)engineConfiguration.getCommandInterceptorsTxRequired().get(0)).setNext((CommandExecutor)this.interceptor);
        this.interceptor.setNext((CommandExecutor)engineConfiguration.getCommandInterceptorsTxRequired().get(1));
        super.starting(description);
    }

    protected void finished(Description description) {
        this.engineRule.getIdentityService().clearAuthentication();
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        ((CommandInterceptor)engineConfiguration.getCommandInterceptorsTxRequired().get(0)).setNext(this.interceptor.getNext());
        this.interceptor.setNext(null);
        super.finished(description);
    }

    public static Collection<AuthorizationScenario[]> asParameters(AuthorizationScenario ... scenarios) {
        ArrayList<AuthorizationScenario[]> scenarioList = new ArrayList<AuthorizationScenario[]>();
        for (AuthorizationScenario scenario : scenarios) {
            scenarioList.add(new AuthorizationScenario[]{scenario});
        }
        return scenarioList;
    }

    public void createUserAndGroup(String userId, String groupId) {
        User user = this.engineRule.getIdentityService().newUser(userId);
        this.engineRule.getIdentityService().saveUser(user);
        this.users.add(user);
        Group group = this.engineRule.getIdentityService().newGroup(groupId);
        this.engineRule.getIdentityService().saveGroup(group);
        this.groups.add(group);
    }

    public void deleteUsersAndGroups() {
        for (User user : this.users) {
            this.engineRule.getIdentityService().deleteUser(user.getId());
        }
        this.users.clear();
        for (Group group : this.groups) {
            this.engineRule.getIdentityService().deleteGroup(group.getId());
        }
        this.groups.clear();
    }

    public AuthorizationScenarioInstanceBuilder init(AuthorizationScenario scenario) {
        AuthorizationScenarioInstanceBuilder builder = new AuthorizationScenarioInstanceBuilder();
        builder.scenario = scenario;
        builder.rule = this;
        return builder;
    }

    public static class AuthorizationScenarioInstanceBuilder {
        protected AuthorizationScenario scenario;
        protected AuthorizationTestRule rule;
        protected String userId;
        protected Map<String, String> resourceBindings = new HashMap<String, String>();

        public AuthorizationScenarioInstanceBuilder withUser(String userId) {
            this.userId = userId;
            return this;
        }

        public AuthorizationScenarioInstanceBuilder bindResource(String key, String value) {
            this.resourceBindings.put(key, value);
            return this;
        }

        public void start() {
            this.rule.start(this.scenario, this.userId, this.resourceBindings);
        }
    }
}

