/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.job;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.Deployment;

public class JobPrioritizationBpmnConstantValueTest
extends PluggableProcessEngineTestCase {
    protected static final long EXPECTED_DEFAULT_PRIORITY = 0L;

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/oneTaskProcess.bpmn20.xml"})
    public void testDefaultPrioritizationAsyncBefore() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("oneTaskProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/oneTaskProcess.bpmn20.xml"})
    public void testDefaultPrioritizationAsyncAfter() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("oneTaskProcess").startBeforeActivity("task1")).execute();
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/oneTimerProcess.bpmn20.xml"})
    public void testDefaultPrioritizationTimer() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("oneTimerProcess").startBeforeActivity("timer1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    public void testProcessDefinitionPrioritizationAsyncBefore() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)10L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    public void testProcessDefinitionPrioritizationAsyncAfter() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task1")).execute();
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)10L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/intermediateTimerJobPrioProcess.bpmn20.xml"})
    public void testProcessDefinitionPrioritizationTimer() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("intermediateTimerJobPrioProcess").startBeforeActivity("timer1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)8L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    public void testActivityPrioritizationAsyncBefore() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)5L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    public void testActivityPrioritizationAsyncAfter() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)5L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/intermediateTimerJobPrioProcess.bpmn20.xml"})
    public void testActivityPrioritizationTimer() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("intermediateTimerJobPrioProcess").startBeforeActivity("timer2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)job);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)4L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/subProcessJobPrioProcess.bpmn20.xml"})
    public void testSubProcessPriorityIsNotDefaultForContainedActivities() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subProcessJobPrioProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)10L, (long)job.getPriority());
    }

    public void testFailOnMalformedInput() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/job/invalidPrioProcess.bpmn20.xml").deploy();
            JobPrioritizationBpmnConstantValueTest.fail((String)"deploying a process with malformed priority should not succeed");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("value 'thisIsNotANumber' for attribute 'jobPriority' is not a valid number", e.getMessage());
        }
    }

    public void testParsePriorityOnNonAsyncActivity() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/job/JobPrioritizationBpmnTest.testParsePriorityOnNonAsyncActivity.bpmn20.xml").deploy();
        this.repositoryService.deleteDeployment(deployment.getId());
    }

    public void testTimerStartEventPriorityOnProcessDefinition() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/job/JobPrioritizationBpmnConstantValueTest.testTimerStartEventPriorityOnProcessDefinition.bpmn20.xml").deploy();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)8L, (long)job.getPriority());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testTimerStartEventPriorityOnActivity() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/job/JobPrioritizationBpmnConstantValueTest.testTimerStartEventPriorityOnActivity.bpmn20.xml").deploy();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)1515L, (long)job.getPriority());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/boundaryTimerJobPrioProcess.bpmn20.xml"})
    public void testBoundaryTimerEventPriority() {
        this.runtimeService.startProcessInstanceByKey("boundaryTimerJobPrioProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)20L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/eventSubprocessTimerJobPrioProcess.bpmn20.xml"})
    public void testEventSubprocessTimerPriority() {
        this.runtimeService.startProcessInstanceByKey("eventSubprocessTimerJobPrioProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)25L, (long)job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/intermediateSignalAsyncProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/job/intermediateSignalCatchJobPrioProcess.bpmn20.xml"})
    public void testAsyncSignalThrowingEventActivityPriority() {
        this.runtimeService.startProcessInstanceByKey("intermediateSignalCatchJobPrioProcess");
        this.runtimeService.startProcessInstanceByKey("intermediateSignalJobPrioProcess");
        Execution signal1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("signal1").singleResult();
        Job signal1Job = (Job)this.managementService.createJobQuery().executionId(signal1Execution.getId()).singleResult();
        Execution signal2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("signal2").singleResult();
        Job signal2Job = (Job)this.managementService.createJobQuery().executionId(signal2Execution.getId()).singleResult();
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)8L, (long)signal1Job.getPriority());
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)4L, (long)signal2Job.getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/intermediateSignalAsyncProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/job/signalStartJobPrioProcess.bpmn20.xml"})
    public void testAsyncSignalThrowingEventSignalStartActivityPriority() {
        this.runtimeService.startProcessInstanceByKey("intermediateSignalJobPrioProcess");
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Job signalStartJob = (Job)this.managementService.createJobQuery().singleResult();
        JobPrioritizationBpmnConstantValueTest.assertNotNull((Object)signalStartJob);
        JobPrioritizationBpmnConstantValueTest.assertEquals((long)4L, (long)signalStartJob.getPriority());
    }
}

