/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmd;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class FoxJobRetryCmdTest
extends PluggableProcessEngineTestCase {
    protected void waitForExecutedJobWithRetriesLeft(int retriesLeft, String jobId) {
        JobQuery jobQuery = this.managementService.createJobQuery();
        if (jobId != null) {
            jobQuery.jobId(jobId);
        }
        Job job = (Job)jobQuery.singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        job = (Job)jobQuery.singleResult();
        if (job.getRetries() != retriesLeft) {
            this.waitForExecutedJobWithRetriesLeft(retriesLeft, jobId);
        }
    }

    protected void waitForExecutedJobWithRetriesLeft(int retriesLeft) {
        this.waitForExecutedJobWithRetriesLeft(retriesLeft, null);
    }

    protected ExecutionEntity refreshExecutionEntity(String executionId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
    }

    protected ExecutionEntity fetchExecutionEntity(String processInstanceId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected Job refreshJob(String jobId) {
        return (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
    }

    protected Job fetchJob(String processInstanceId) {
        return (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected void stillOneJobWithExceptionAndRetriesLeft(String jobId) {
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().jobId(jobId).withException().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().jobId(jobId).withRetriesLeft().count());
    }

    protected void stillOneJobWithExceptionAndRetriesLeft() {
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void testFailedServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedUserTask.bpmn20.xml"})
    public void testFailedUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedUserTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedBusinessRuleTask.bpmn20.xml"})
    public void testFailedBusinessRuleTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBusinessRuleTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedCallActivity.bpmn20.xml"})
    public void testFailedCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedCallActivity");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedScriptTask.bpmn20.xml"})
    public void testFailedScriptTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedScriptTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedSendTask.bpmn20.xml"})
    public void testFailedSendTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSendTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedSubProcess.bpmn20.xml"})
    public void testFailedSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSubProcess");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedTask.bpmn20.xml"})
    public void testFailedTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedTransaction.bpmn20.xml"})
    public void testFailedTransaction() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedReceiveTask.bpmn20.xml"})
    public void testFailedReceiveTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedReceiveTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedStartTimerEvent.bpmn20.xml"})
    public void testFailedTimerStartEvent() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        String jobId = job.getId();
        this.waitForExecutedJobWithRetriesLeft(4, jobId);
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(2, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(1, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(0, jobId);
        job = this.refreshJob(jobId);
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().jobId(jobId).withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedBoundaryTimerEvent.bpmn20.xml"})
    public void testFailedBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBoundaryTimerEvent");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(2);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(1);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedIntermediateCatchingTimerEvent.bpmn20.xml"})
    public void testFailedIntermediateCatchingTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedIntermediateCatchingTimerEvent");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(2);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(1);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testBrokenFoxJobRetryValue.bpmn20.xml"})
    public void testBrokenFoxJobRetryValue() {
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0, job.getId());
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment
    public void FAILING_testRetryOnTimerStartEventInEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
            FoxJobRetryCmdTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void FAILING_testFailedRetryWithTimeShift() throws ParseException {
        Date tenMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:50:00 CEST");
        Date fiveMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:55:00 CEST");
        Date twoMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:58:00 CEST");
        ClockUtil.setCurrentTime((Date)tenMinutesBeforeTimeShift);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        List<JobEntity> acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((int)1, (int)acquirableJobs.size());
        this.waitForExecutedJobWithRetriesLeft(4);
        JobEntity job = (JobEntity)this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertTrue((boolean)tenMinutesBeforeTimeShift.before(job.getLockExpirationTime()));
        FoxJobRetryCmdTest.assertEquals((Object)fiveMinutesBeforeTimeShift, (Object)job.getLockExpirationTime());
        FoxJobRetryCmdTest.assertTrue((boolean)twoMinutesBeforeTimeShift.after(job.getLockExpirationTime()));
        acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((int)0, (int)acquirableJobs.size());
        ClockUtil.setCurrentTime((Date)twoMinutesBeforeTimeShift);
        acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((int)1, (int)acquirableJobs.size());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = (JobEntity)this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertTrue((boolean)twoMinutesBeforeTimeShift.before(job.getLockExpirationTime()));
        acquirableJobs = this.findAndLockAcquirableJobs();
        FoxJobRetryCmdTest.assertEquals((String)"Job shouldn't be acquirable", (int)0, (int)acquirableJobs.size());
        ClockUtil.reset();
    }

    protected Date createDateFromLocalString(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z", Locale.US);
        return dateFormat.parse(dateString);
    }

    protected List<JobEntity> findAndLockAcquirableJobs() {
        return (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<List<JobEntity>>(){

            public List<JobEntity> execute(CommandContext commandContext) {
                List jobs = commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
                for (JobEntity job : jobs) {
                    job.setLockOwner("test");
                }
                return jobs;
            }
        });
    }
}

