/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.ExecuteJobsCmd;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.slf4j.Logger;

public class CompetingJobExecutionTest
extends PluggableProcessEngineTestCase {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected static ControllableThread activeThread;

    @Deployment
    public void testCompetingJobExecutionDefaultRetryStrategy() {
        this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        List currentJobs = this.managementService.createJobQuery().list();
        CompetingJobExecutionTest.assertEquals((int)2, (int)currentJobs.size());
        JobExecutionThread threadOne = new JobExecutionThread(((Job)currentJobs.get(0)).getId());
        threadOne.startAndWaitUntilControlIsReturned();
        JobExecutionThread threadTwo = new JobExecutionThread(((Job)currentJobs.get(1)).getId());
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingJobExecutionTest.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingJobExecutionTest.assertNotNull((Object)((Object)threadTwo.exception));
        Job remainingJob = (Job)this.managementService.createJobQuery().singleResult();
        CompetingJobExecutionTest.assertEquals((int)((Job)currentJobs.get(1)).getRetries(), (int)remainingJob.getRetries());
        CompetingJobExecutionTest.assertNotNull((Object)remainingJob.getExceptionMessage());
        JobEntity jobEntity = (JobEntity)remainingJob;
        CompetingJobExecutionTest.assertNull((Object)jobEntity.getLockOwner());
        CompetingJobExecutionTest.assertNull((Object)jobEntity.getLockExpirationTime());
    }

    @Deployment
    public void testCompetingJobExecutionFoxRetryStrategy() {
        this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        List currentJobs = this.managementService.createJobQuery().list();
        CompetingJobExecutionTest.assertEquals((int)2, (int)currentJobs.size());
        JobExecutionThread threadOne = new JobExecutionThread(((Job)currentJobs.get(0)).getId());
        threadOne.startAndWaitUntilControlIsReturned();
        JobExecutionThread threadTwo = new JobExecutionThread(((Job)currentJobs.get(1)).getId());
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingJobExecutionTest.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingJobExecutionTest.assertNotNull((Object)((Object)threadTwo.exception));
        Job remainingJob = (Job)this.managementService.createJobQuery().singleResult();
        CompetingJobExecutionTest.assertEquals((int)5, (int)remainingJob.getRetries());
        CompetingJobExecutionTest.assertNotNull((Object)remainingJob.getExceptionMessage());
        JobEntity jobEntity = (JobEntity)remainingJob;
        CompetingJobExecutionTest.assertNull((Object)jobEntity.getLockOwner());
        CompetingJobExecutionTest.assertNotNull((Object)jobEntity.getLockExpirationTime());
    }

    public class JobExecutionThread
    extends ControllableThread {
        OptimisticLockingException exception;
        String jobId;

        JobExecutionThread(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingJobExecutionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new ExecuteJobsCmd(this.jobId)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }
}

