/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.tasklistener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;

public class RecorderTaskListener
implements TaskListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static List<RecordedTaskEvent> recordedEvents = new ArrayList<RecordedTaskEvent>();

    public void notify(DelegateTask task) {
        recordedEvents.add(new RecordedTaskEvent(task.getId(), task.getExecutionId(), task.getEventName()));
    }

    public static void clear() {
        recordedEvents.clear();
    }

    public static List<RecordedTaskEvent> getRecordedEvents() {
        return recordedEvents;
    }

    public static class RecordedTaskEvent {
        protected String taskId;
        protected String executionId;
        protected String event;

        public RecordedTaskEvent(String taskId, String executionId, String event) {
            this.executionId = executionId;
            this.taskId = taskId;
            this.event = event;
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getEvent() {
            return this.event;
        }
    }
}

