/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.taskforms;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class TaskFormsTest
extends PluggableProcessEngineTestCase {
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.createMembership("fozzie", "management");
    }

    public void tearDown() throws Exception {
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/taskforms/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/examples/taskforms/approve.form", "org/camunda/bpm/engine/test/examples/taskforms/request.form", "org/camunda/bpm/engine/test/examples/taskforms/adjustRequest.form"})
    public void testTaskFormsWithVacationRequestProcess() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        Object startForm = this.formService.getRenderedStartForm(procDefId, "juel");
        TaskFormsTest.assertNotNull((Object)startForm);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        String processDefinitionId = processDefinition.getId();
        TaskFormsTest.assertEquals((String)"org/camunda/bpm/engine/test/examples/taskforms/request.form", (String)this.formService.getStartFormData(processDefinitionId).getFormKey());
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("employeeName", "kermit");
        formProperties.put("numberOfDays", "4");
        formProperties.put("vacationMotivation", "I'm tired");
        this.formService.submitStartFormData(procDefId, formProperties);
        Task task = (Task)this.taskService.createTaskQuery().taskCandidateGroup("management").singleResult();
        TaskFormsTest.assertEquals((String)"Vacation request by kermit", (String)task.getDescription());
        Object taskForm = this.formService.getRenderedTaskForm(task.getId(), "juel");
        TaskFormsTest.assertNotNull((Object)taskForm);
        this.taskService.complete(task.getId(), CollectionUtil.singletonMap((String)"vacationApproved", (Object)"false"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormsTest.assertEquals((String)"Adjust vacation request", (String)task.getName());
    }

    @Deployment
    public void testTaskFormUnavailable() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        TaskFormsTest.assertNull((Object)this.formService.getRenderedStartForm(procDefId));
        this.runtimeService.startProcessInstanceByKey("noStartOrTaskForm");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormsTest.assertNull((Object)this.formService.getRenderedTaskForm(task.getId()));
    }
}

