/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class HistoricTaskInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testHistoricTaskInstance() throws Exception {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest").getId();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        Task runtimeTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        runtimeTask.setPriority(1234);
        Date dueDate = sdf.parse("01/02/2003 04:05:06");
        runtimeTask.setDueDate(dueDate);
        this.taskService.saveTask(runtimeTask);
        String taskId = runtimeTask.getId();
        String taskDefinitionKey = runtimeTask.getTaskDefinitionKey();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertEquals((String)taskId, (String)historicTaskInstance.getId());
        HistoricTaskInstanceTest.assertEquals((int)1234, (int)historicTaskInstance.getPriority());
        HistoricTaskInstanceTest.assertEquals((String)"Clean up", (String)historicTaskInstance.getName());
        HistoricTaskInstanceTest.assertEquals((String)"Schedule an engineering meeting for next week with the new hire.", (String)historicTaskInstance.getDescription());
        HistoricTaskInstanceTest.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
        HistoricTaskInstanceTest.assertEquals((String)"kermit", (String)historicTaskInstance.getAssignee());
        HistoricTaskInstanceTest.assertEquals((String)taskDefinitionKey, (String)historicTaskInstance.getTaskDefinitionKey());
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getEndTime());
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getDurationInMillis());
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getCaseDefinitionId());
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getCaseInstanceId());
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getCaseExecutionId());
        HistoricTaskInstanceTest.assertEquals((String)((TaskEntity)runtimeTask).getExecution().getActivityInstanceId(), (String)historicTaskInstance.getActivityInstanceId());
        this.runtimeService.setVariable(processInstanceId, "deadline", (Object)"yesterday");
        Date now = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 1000L));
        this.taskService.complete(taskId);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertEquals((String)taskId, (String)historicTaskInstance.getId());
        HistoricTaskInstanceTest.assertEquals((int)1234, (int)historicTaskInstance.getPriority());
        HistoricTaskInstanceTest.assertEquals((String)"Clean up", (String)historicTaskInstance.getName());
        HistoricTaskInstanceTest.assertEquals((String)"Schedule an engineering meeting for next week with the new hire.", (String)historicTaskInstance.getDescription());
        HistoricTaskInstanceTest.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
        HistoricTaskInstanceTest.assertEquals((String)"kermit", (String)historicTaskInstance.getAssignee());
        HistoricTaskInstanceTest.assertEquals((String)"completed", (String)historicTaskInstance.getDeleteReason());
        HistoricTaskInstanceTest.assertEquals((String)taskDefinitionKey, (String)historicTaskInstance.getTaskDefinitionKey());
        HistoricTaskInstanceTest.assertNotNull((Object)historicTaskInstance.getEndTime());
        HistoricTaskInstanceTest.assertNotNull((Object)historicTaskInstance.getDurationInMillis());
        HistoricTaskInstanceTest.assertTrue((historicTaskInstance.getDurationInMillis() >= 1000L ? 1 : 0) != 0);
        HistoricTaskInstanceTest.assertTrue((((HistoricTaskInstanceEntity)historicTaskInstance).getDurationRaw() >= 1000L ? 1 : 0) != 0);
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getCaseDefinitionId());
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getCaseInstanceId());
        HistoricTaskInstanceTest.assertNull((Object)historicTaskInstance.getCaseExecutionId());
        this.historyService.deleteHistoricTaskInstance(taskId);
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
    }

    public void testDeleteHistoricTaskInstance() throws Exception {
        this.historyService.deleteHistoricTaskInstance("unexistingId");
    }

    @Deployment
    public void testHistoricTaskInstanceQuery() throws Exception {
        ProcessInstance finishedInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskQueryTest");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(finishedInstance.getId()).singleResult();
        task.setPriority(1234);
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 04:05:06");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.complete(taskId);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskId("unexistingtaskid").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskName("Clean up").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskName("unexistingname").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("Clean u%").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("%lean up").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("%lean u%").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("%unexistingname%").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescription("Historic task description").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescription("unexistingdescription").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("%task description").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("Historic task %").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("%task%").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("%unexistingdescripton%").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().executionId(finishedInstance.getId()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().executionId("unexistingexecution").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(finishedInstance.getId()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId("unexistingid").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionId(finishedInstance.getProcessDefinitionId()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionId("unexistingdefinitionid").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionName("Historic task query test process").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionName("unexistingdefinitionname").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey("HistoricTaskQueryTest").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey("unexistingdefinitionkey").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssignee("kermit").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssignee("johndoe").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("%ermit").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("kermi%").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("%ermi%").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("%johndoe%").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDeleteReason("completed").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDeleteReason("deleted").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKey("task").count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKey("unexistingkey").count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskPriority(Integer.valueOf(1234)).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskPriority(Integer.valueOf(5678)).count());
        Calendar anHourAgo = Calendar.getInstance();
        anHourAgo.setTime(dueDate);
        anHourAgo.add(10, -1);
        Calendar anHourLater = Calendar.getInstance();
        anHourLater.setTime(dueDate);
        anHourLater.add(10, 1);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(anHourAgo.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(anHourLater.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueBefore(anHourLater.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueBefore(anHourAgo.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueAfter(anHourAgo.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueAfter(anHourLater.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueBefore(anHourLater.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueBefore(anHourAgo.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueAfter(anHourAgo.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueAfter(anHourLater.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueBefore(anHourAgo.getTime()).taskDueAfter(anHourLater.getTime()).count());
        this.runtimeService.startProcessInstanceByKey("HistoricTaskQueryTest");
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().finished().count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().unfinished().count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().unfinished().finished().count());
    }

    @Deployment
    public void testHistoricTaskInstanceQueryByProcessVariableValue() throws Exception {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("hallo", "steffen");
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest", variables).getId();
            Task runtimeTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            String taskId = runtimeTask.getId();
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("hallo", (Object)"steffen").singleResult();
            HistoricTaskInstanceTest.assertNotNull((Object)historicTaskInstance);
            HistoricTaskInstanceTest.assertEquals((String)taskId, (String)historicTaskInstance.getId());
            this.taskService.complete(taskId);
            HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).count());
            this.historyService.deleteHistoricTaskInstance(taskId);
            HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        }
    }

    public void testHistoricTaskInstanceAssignment() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertNull((Object)hti.getAssignee());
        this.taskService.setAssignee(task.getId(), "jonny");
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertEquals((String)"jonny", (String)hti.getAssignee());
        HistoricTaskInstanceTest.assertNull((Object)hti.getOwner());
        this.taskService.deleteTask(task.getId());
        this.historyService.deleteHistoricTaskInstance(hti.getId());
    }

    @Deployment
    public void testHistoricTaskInstanceAssignmentListener() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("assignee", "jonny");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        HistoricActivityInstance hai = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult();
        HistoricTaskInstanceTest.assertEquals((String)"jonny", (String)hai.getAssignee());
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertEquals((String)"jonny", (String)hti.getAssignee());
        HistoricTaskInstanceTest.assertNull((Object)hti.getOwner());
    }

    public void testHistoricTaskInstanceOwner() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertNull((Object)hti.getOwner());
        this.taskService.setOwner(task.getId(), "jonny");
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertEquals((String)"jonny", (String)hti.getOwner());
        this.taskService.deleteTask(task.getId());
        this.historyService.deleteHistoricTaskInstance(hti.getId());
    }

    public void testHistoricTaskInstancePriority() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertEquals((int)50, (int)hti.getPriority());
        this.taskService.setPriority(task.getId(), 100);
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        HistoricTaskInstanceTest.assertEquals((int)100, (int)hti.getPriority());
        this.taskService.deleteTask(task.getId());
        this.historyService.deleteHistoricTaskInstance(hti.getId());
    }

    @Deployment
    public void testHistoricTaskInstanceQueryProcessFinished() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("TwoTaskHistoricTaskQueryTest");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processFinished().count());
        this.taskService.complete(task.getId());
        HistoricTaskInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processFinished().count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.complete(task.getId());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().count());
        HistoricTaskInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processFinished().count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().processFinished().count());
    }

    @Deployment
    public void testHistoricTaskInstanceQuerySorting() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("HistoricTaskQueryTest");
        String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(instance.getId()).singleResult()).getId();
        this.taskService.complete(taskId);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByDeleteReason().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByExecutionId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessDefinitionId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDescription().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskName().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDefinitionKey().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskPriority().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDueDate().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskFollowUpDate().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseDefinitionId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseInstanceId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseExecutionId().asc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByDeleteReason().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByExecutionId().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceId().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceStartTime().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessDefinitionId().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDescription().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskName().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDefinitionKey().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskPriority().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskId().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDueDate().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskFollowUpDate().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseDefinitionId().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseInstanceId().desc()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseExecutionId().desc()).count());
    }

    public void testInvalidSorting() {
        try {
            this.historyService.createHistoricTaskInstanceQuery().asc();
            HistoricTaskInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricTaskInstanceQuery().desc();
            HistoricTaskInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().list();
            HistoricTaskInstanceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryByFollowUpDate() throws Exception {
        Calendar otherDate = Calendar.getInstance();
        this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Date followUpDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(followUpDate);
        this.taskService.saveTask(task);
        HistoricTaskInstanceTest.assertEquals((Object)followUpDate, (Object)((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpDate(followUpDate).count());
        otherDate.setTime(followUpDate);
        otherDate.add(1, 1);
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpDate(otherDate.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpBefore(otherDate.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpAfter(otherDate.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpAfter(otherDate.getTime()).taskFollowUpDate(followUpDate).count());
        otherDate.add(1, -2);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpAfter(otherDate.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpBefore(otherDate.getTime()).count());
        HistoricTaskInstanceTest.assertEquals((Object)followUpDate, (Object)((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpBefore(otherDate.getTime()).taskFollowUpDate(followUpDate).count());
        this.taskService.complete(task.getId());
        HistoricTaskInstanceTest.assertEquals((Object)followUpDate, (Object)((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpDate(followUpDate).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryByActivityInstanceId() throws Exception {
        this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId});
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)1, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryByActivityInstanceIds() throws Exception {
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        ProcessInstance pi2 = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        String activityInstanceId1 = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi1.getId()).activityId("task").singleResult()).getId();
        String activityInstanceId2 = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi2.getId()).activityId("task").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId1, activityInstanceId2});
        HistoricTaskInstanceTest.assertEquals((long)2L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)2, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryByInvalidActivityInstanceId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.activityInstanceIdIn(new String[]{"invalid"});
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            query.activityInstanceIdIn(null);
            HistoricTaskInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.activityInstanceIdIn(new String[]{null});
            HistoricTaskInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            String[] values = new String[]{"a", null, "b"};
            query.activityInstanceIdIn(values);
            HistoricTaskInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionId(caseDefinitionId);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricTaskInstanceTest.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        HistoricTaskInstanceTest.assertNotNull((Object)task);
        HistoricTaskInstanceTest.assertEquals((String)caseDefinitionId, (String)task.getCaseDefinitionId());
        HistoricTaskInstanceTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        HistoricTaskInstanceTest.assertEquals((String)humanTaskId, (String)task.getCaseExecutionId());
    }

    public void testQueryByInvalidCaseDefinitionId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionId("invalid");
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
        query.caseDefinitionId(null);
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionKey() {
        String key = "oneTaskCase";
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey(key).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionKey(key);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricTaskInstanceTest.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        HistoricTaskInstanceTest.assertNotNull((Object)task);
        HistoricTaskInstanceTest.assertEquals((String)caseDefinitionId, (String)task.getCaseDefinitionId());
        HistoricTaskInstanceTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        HistoricTaskInstanceTest.assertEquals((String)humanTaskId, (String)task.getCaseExecutionId());
    }

    public void testQueryByInvalidCaseDefinitionKey() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionKey("invalid");
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
        query.caseDefinitionKey(null);
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionName() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        String caseDefinitionName = caseDefinition.getName();
        String caseDefinitionId = caseDefinition.getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionName(caseDefinitionName);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricTaskInstanceTest.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        HistoricTaskInstanceTest.assertNotNull((Object)task);
        HistoricTaskInstanceTest.assertEquals((String)caseDefinitionId, (String)task.getCaseDefinitionId());
        HistoricTaskInstanceTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        HistoricTaskInstanceTest.assertEquals((String)humanTaskId, (String)task.getCaseExecutionId());
    }

    public void testQueryByInvalidCaseDefinitionName() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionName("invalid");
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
        query.caseDefinitionName(null);
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        String key = "oneTaskCase";
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey(key).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricTaskInstanceTest.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        HistoricTaskInstanceTest.assertNotNull((Object)task);
        HistoricTaskInstanceTest.assertEquals((String)caseDefinitionId, (String)task.getCaseDefinitionId());
        HistoricTaskInstanceTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        HistoricTaskInstanceTest.assertEquals((String)humanTaskId, (String)task.getCaseExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricTaskInstanceTest.testQueryByCaseInstanceIdHierarchy.cmmn", "org/camunda/bpm/engine/test/history/HistoricTaskInstanceTest.testQueryByCaseInstanceIdHierarchy.bpmn20.xml"})
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        HistoricTaskInstanceTest.assertEquals((long)2L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)2, (int)query.list().size());
        for (HistoricTaskInstance task : query.list()) {
            HistoricTaskInstanceTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
            HistoricTaskInstanceTest.assertNull((Object)task.getCaseDefinitionId());
            HistoricTaskInstanceTest.assertNull((Object)task.getCaseExecutionId());
            this.taskService.complete(task.getId());
        }
        HistoricTaskInstanceTest.assertEquals((long)3L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)3, (int)query.list().size());
        for (HistoricTaskInstance task : query.list()) {
            HistoricTaskInstanceTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
            HistoricTaskInstanceTest.assertNull((Object)task.getCaseDefinitionId());
            HistoricTaskInstanceTest.assertNull((Object)task.getCaseExecutionId());
        }
    }

    public void testQueryByInvalidCaseInstanceId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseInstanceId("invalid");
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
        query.caseInstanceId(null);
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        String key = "oneTaskCase";
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey(key).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseExecutionId(humanTaskId);
        HistoricTaskInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricTaskInstanceTest.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        HistoricTaskInstanceTest.assertNotNull((Object)task);
        HistoricTaskInstanceTest.assertEquals((String)caseDefinitionId, (String)task.getCaseDefinitionId());
        HistoricTaskInstanceTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
        HistoricTaskInstanceTest.assertEquals((String)humanTaskId, (String)task.getCaseExecutionId());
    }

    public void testQueryByInvalidCaseExecutionId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseExecutionId("invalid");
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
        query.caseExecutionId(null);
        HistoricTaskInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricTaskInstanceTest.assertEquals((int)0, (int)query.list().size());
        HistoricTaskInstanceTest.assertNull((Object)query.singleResult());
    }

    public void testHistoricTaskInstanceCaseInstanceId() {
        Task task = this.taskService.newTask();
        task.setCaseInstanceId("aCaseInstanceId");
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
        HistoricTaskInstanceTest.assertEquals((String)"aCaseInstanceId", (String)hti.getCaseInstanceId());
        task.setCaseInstanceId("anotherCaseInstanceId");
        this.taskService.saveTask(task);
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
        HistoricTaskInstanceTest.assertEquals((String)"anotherCaseInstanceId", (String)hti.getCaseInstanceId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionKeyProperty() {
        String key = "oneTaskProcess";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        HistoricTaskInstance task = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).taskDefinitionKey("theTask").singleResult();
        HistoricTaskInstanceTest.assertNotNull((Object)task.getProcessDefinitionKey());
        HistoricTaskInstanceTest.assertEquals((String)key, (String)task.getProcessDefinitionKey());
        HistoricTaskInstanceTest.assertNull((Object)task.getCaseDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCaseDefinitionKeyProperty() {
        String key = "oneTaskCase";
        String caseInstanceId = this.caseService.createCaseInstanceByKey(key).getId();
        String humanTask = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(humanTask);
        HistoricTaskInstance task = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().caseInstanceId(caseInstanceId).taskDefinitionKey("PI_HumanTask_1").singleResult();
        HistoricTaskInstanceTest.assertNotNull((Object)task.getCaseDefinitionKey());
        HistoricTaskInstanceTest.assertEquals((String)key, (String)task.getCaseDefinitionKey());
        HistoricTaskInstanceTest.assertNull((Object)task.getProcessDefinitionKey());
    }
}

