/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;

public class UserOperationLogQueryTest
extends AbstractUserOperationLogTest {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_TASK_CASE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    private ProcessInstance process;
    private Task userTask;
    private Execution execution;
    private String processTaskId;
    private Date today = new Date(ClockUtil.getCurrentTime().getTime() / 1000L * 1000L);
    private Date tomorrow = new Date((ClockUtil.getCurrentTime().getTime() + 86400000L) / 1000L * 1000L);
    private Date yesterday = new Date((ClockUtil.getCurrentTime().getTime() - 86400000L) / 1000L * 1000L);

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.userTask != null) {
            this.historyService.deleteHistoricTaskInstance(this.userTask.getId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQuery() {
        int i;
        int i2;
        this.createLogEntries();
        UserOperationLogQueryTest.assertEquals((long)17L, (long)this.query().count());
        UserOperationLogQueryTest.assertEquals((long)11L, (long)this.query().entityType("Task").count());
        UserOperationLogQueryTest.assertEquals((long)4L, (long)this.query().entityType("IdentityLink").count());
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("Attachment").count());
        UserOperationLogQueryTest.assertEquals((long)0L, (long)this.query().entityType("unknown entity type").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("Create").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("SetPriority").count());
        UserOperationLogQueryTest.assertEquals((long)4L, (long)this.query().operationType("Update").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddUserLink").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteUserLink").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddGroupLink").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteGroupLink").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddAttachment").count());
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteAttachment").count());
        UserOperationLogQueryTest.assertEquals((long)11L, (long)this.query().processDefinitionId(this.process.getProcessDefinitionId()).count());
        UserOperationLogQueryTest.assertEquals((long)11L, (long)this.query().processInstanceId(this.process.getId()).count());
        UserOperationLogQueryTest.assertEquals((long)11L, (long)this.query().executionId(this.execution.getId()).count());
        UserOperationLogQueryTest.assertEquals((long)11L, (long)this.query().taskId(this.processTaskId).count());
        UserOperationLogQueryTest.assertEquals((long)6L, (long)this.query().taskId(this.userTask.getId()).count());
        UserOperationLogQueryTest.assertEquals((long)11L, (long)this.query().userId("icke").count());
        UserOperationLogQueryTest.assertEquals((long)6L, (long)this.query().userId("er").count());
        UserOperationLogQuery updates = this.query().operationType("Update");
        String updateOperationId = ((UserOperationLogEntry)updates.list().get(0)).getOperationId();
        UserOperationLogQueryTest.assertEquals((long)updates.count(), (long)this.query().operationId(updateOperationId).count());
        UserOperationLogQueryTest.assertEquals((long)3L, (long)this.query().property("assignee").count());
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().property("owner").count());
        List ascLog = ((UserOperationLogQuery)this.query().orderByTimestamp().asc()).list();
        for (i2 = 0; i2 < 4; ++i2) {
            UserOperationLogQueryTest.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 4; i2 < 12; ++i2) {
            UserOperationLogQueryTest.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 12; i2 < 16; ++i2) {
            UserOperationLogQueryTest.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        List descLog = ((UserOperationLogQuery)this.query().orderByTimestamp().desc()).list();
        for (i = 0; i < 4; ++i) {
            UserOperationLogQueryTest.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 4; i < 11; ++i) {
            UserOperationLogQueryTest.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 11; i < 15; ++i) {
            UserOperationLogQueryTest.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        UserOperationLogQueryTest.assertEquals((long)4L, (long)this.query().beforeTimestamp(this.today).count());
        UserOperationLogQueryTest.assertEquals((long)12L, (long)this.query().beforeTimestamp(this.tomorrow).count());
        UserOperationLogQueryTest.assertEquals((long)13L, (long)this.query().afterTimestamp(this.yesterday).count());
        UserOperationLogQueryTest.assertEquals((long)5L, (long)this.query().afterTimestamp(this.today).count());
        UserOperationLogQueryTest.assertEquals((long)0L, (long)this.query().afterTimestamp(this.today).beforeTimestamp(this.yesterday).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryWithBackwardCompatibility() {
        this.createLogEntries();
        UserOperationLogQueryTest.assertEquals((long)17L, (long)this.query().count());
        UserOperationLogQueryTest.assertEquals((long)11L, (long)this.query().entityType("Task").count());
        UserOperationLogQueryTest.assertEquals((long)4L, (long)this.query().entityType("IdentityLink").count());
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("Attachment").count());
        UserOperationLogQueryTest.assertEquals((long)0L, (long)this.query().entityType("unknown entity type").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceById(this.process.getId());
        this.runtimeService.activateProcessInstanceById(this.process.getId());
        this.runtimeService.deleteProcessInstance(this.process.getId(), "a delete reason");
        UserOperationLogQueryTest.assertEquals((long)3L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry deleteEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Delete").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)deleteEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getId(), (String)deleteEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertNotNull((Object)deleteEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)deleteEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)deleteEntry.getDeploymentId());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Suspend").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)suspendEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getId(), (String)suspendEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertNotNull((Object)suspendEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)suspendEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Activate").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)activateEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getId(), (String)activateEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertNotNull((Object)activateEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)activateEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)activateEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsByProcessDefinitionId() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(this.process.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Suspend").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)suspendEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)suspendEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertNull((Object)suspendEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)suspendEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)suspendEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Activate").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)activateEntry);
        UserOperationLogQueryTest.assertNull((Object)activateEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)activateEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)activateEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)activateEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsByProcessDefinitionKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Suspend").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)suspendEntry);
        UserOperationLogQueryTest.assertNull((Object)suspendEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertNull((Object)suspendEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)suspendEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertNull((Object)suspendEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Activate").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)activateEntry);
        UserOperationLogQueryTest.assertNull((Object)activateEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertNull((Object)activateEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)activateEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertNull((Object)activateEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessDefinitionOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendProcessDefinition").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)suspendDefinitionEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)suspendDefinitionEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)suspendDefinitionEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)suspendDefinitionEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendDefinitionEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"suspended", (String)suspendDefinitionEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        UserOperationLogEntry activateDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateProcessDefinition").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)activateDefinitionEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)activateDefinitionEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)activateDefinitionEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)activateDefinitionEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateDefinitionEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"active", (String)activateDefinitionEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)activateDefinitionEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessDefinitionOperationsByKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", true, null);
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("SuspendProcessDefinition").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)suspendDefinitionEntry);
        UserOperationLogQueryTest.assertNull((Object)suspendDefinitionEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)suspendDefinitionEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertNull((Object)suspendDefinitionEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendDefinitionEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"suspended", (String)suspendDefinitionEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        UserOperationLogEntry activateDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("ActivateProcessDefinition").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)activateDefinitionEntry);
        UserOperationLogQueryTest.assertNull((Object)activateDefinitionEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)activateDefinitionEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertNull((Object)activateDefinitionEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateDefinitionEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"active", (String)activateDefinitionEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)activateDefinitionEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryJobOperations() {
        this.process = this.runtimeService.startProcessInstanceByKey("process");
        this.managementService.suspendJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.activateJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.suspendJobByProcessInstanceId(this.process.getId());
        this.managementService.activateJobByProcessInstanceId(this.process.getId());
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("JobDefinition").count());
        UserOperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("Job").count());
        UserOperationLogEntry activeJobDefinitionEntry = (UserOperationLogEntry)this.query().entityType("JobDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateJobDefinition").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)activeJobDefinitionEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)activeJobDefinitionEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)activeJobDefinitionEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)activeJobDefinitionEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"active", (String)activeJobDefinitionEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)activeJobDefinitionEntry.getOrgValue());
        UserOperationLogEntry activateJobIdEntry = (UserOperationLogEntry)this.query().entityType("Job").processInstanceId(this.process.getProcessInstanceId()).operationType("ActivateJob").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)activateJobIdEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessInstanceId(), (String)activateJobIdEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)activateJobIdEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateJobIdEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"active", (String)activateJobIdEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)activateJobIdEntry.getOrgValue());
        UserOperationLogEntry suspendJobDefinitionEntry = (UserOperationLogEntry)this.query().entityType("JobDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendJobDefinition").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)suspendJobDefinitionEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)suspendJobDefinitionEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)suspendJobDefinitionEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendJobDefinitionEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"suspended", (String)suspendJobDefinitionEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)suspendJobDefinitionEntry.getOrgValue());
        UserOperationLogEntry suspendedJobEntry = (UserOperationLogEntry)this.query().entityType("Job").processInstanceId(this.process.getProcessInstanceId()).operationType("SuspendJob").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)suspendedJobEntry);
        UserOperationLogQueryTest.assertEquals((String)this.process.getProcessInstanceId(), (String)suspendedJobEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)suspendedJobEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendedJobEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)"suspended", (String)suspendedJobEntry.getNewValue());
        UserOperationLogQueryTest.assertNull((Object)suspendedJobEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void testQueryJobRetryOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(this.process.getProcessInstanceId()).singleResult();
        this.managementService.setJobRetries(job.getId(), 10);
        UserOperationLogQueryTest.assertEquals((long)1L, (long)this.query().entityType("Job").operationType("SetJobRetries").count());
        UserOperationLogEntry jobRetryEntry = (UserOperationLogEntry)this.query().entityType("Job").jobId(job.getId()).operationType("SetJobRetries").singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)jobRetryEntry);
        UserOperationLogQueryTest.assertEquals((String)job.getId(), (String)jobRetryEntry.getJobId());
        UserOperationLogQueryTest.assertEquals((String)"3", (String)jobRetryEntry.getOrgValue());
        UserOperationLogQueryTest.assertEquals((String)"10", (String)jobRetryEntry.getNewValue());
        UserOperationLogQueryTest.assertEquals((String)"retries", (String)jobRetryEntry.getProperty());
        UserOperationLogQueryTest.assertEquals((String)job.getJobDefinitionId(), (String)jobRetryEntry.getJobDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)job.getProcessInstanceId(), (String)jobRetryEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertEquals((String)job.getProcessDefinitionKey(), (String)jobRetryEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)job.getProcessDefinitionId(), (String)jobRetryEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)jobRetryEntry.getDeploymentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryJobDefinitionOperationWithDelayedJobDefinition() {
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processDefinitionId = process.getProcessDefinitionId();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        ClockUtil.setCurrentTime((Date)this.today);
        long oneWeekFromStartTime = this.today.getTime() + 604800000L;
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, false, new Date(oneWeekFromStartTime));
        Long jobDefinitionEntryCount = this.query().entityType("JobDefinition").operationType("ActivateJobDefinition").processDefinitionId(processDefinitionId).count();
        UserOperationLogQueryTest.assertEquals((long)1L, (long)jobDefinitionEntryCount);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        jobDefinitionEntryCount = this.query().entityType("JobDefinition").operationType("ActivateJobDefinition").processDefinitionId(processDefinitionId).count();
        UserOperationLogQueryTest.assertEquals((long)1L, (long)jobDefinitionEntryCount);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-job-definition");
                return null;
            }
        });
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testQueryProcessDefinitionOperationWithDelayedProcessDefinition() {
        ClockUtil.setCurrentTime((Date)this.today);
        long hourInMs = 3600000L;
        String key = "oneFailingServiceTaskProcess";
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey(key, params);
        this.repositoryService.suspendProcessDefinitionByKey(key, false, new Date(this.today.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)timerToSuspendProcessDefinition);
        Long processDefinitionEntryCount = this.query().entityType("ProcessDefinition").operationType("SuspendProcessDefinition").processDefinitionKey(key).count();
        UserOperationLogQueryTest.assertEquals((long)1L, (long)processDefinitionEntryCount);
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        processDefinitionEntryCount = this.query().entityType("ProcessDefinition").operationType("SuspendProcessDefinition").processDefinitionKey(key).count();
        UserOperationLogQueryTest.assertEquals((long)1L, (long)processDefinitionEntryCount);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                return null;
            }
        });
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceModificationOperation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
        UserOperationLogQuery logQuery = this.query().entityType("ProcessInstance").operationType("ModifyProcessInstance");
        UserOperationLogQueryTest.assertEquals((long)1L, (long)logQuery.count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
        UserOperationLogQueryTest.assertEquals((String)processInstanceId, (String)logEntry.getProcessInstanceId());
        UserOperationLogQueryTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)logEntry.getProcessDefinitionId());
        UserOperationLogQueryTest.assertEquals((String)definition.getKey(), (String)logEntry.getProcessDefinitionKey());
        UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)logEntry.getDeploymentId());
        UserOperationLogQueryTest.assertEquals((String)"ModifyProcessInstance", (String)logEntry.getOperationType());
        UserOperationLogQueryTest.assertEquals((String)"ProcessInstance", (String)logEntry.getEntityType());
        UserOperationLogQueryTest.assertNull((Object)logEntry.getProperty());
        UserOperationLogQueryTest.assertNull((Object)logEntry.getOrgValue());
        UserOperationLogQueryTest.assertNull((Object)logEntry.getNewValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddExecutionVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable1", (Object)"THIS IS TESTVARIABLE!!!");
        this.verifyVariableOperationAsserts(1, "SetVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddExecutionVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(this.process.getId(), this.createMapForVariableAddition());
        this.verifyVariableOperationAsserts(1, "SetVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddExecutionVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"foo");
        this.runtimeService.setVariables(this.process.getId(), this.createMapForVariableAddition());
        this.runtimeService.setVariable(this.process.getId(), "testVariable4", (Object)"bar");
        this.verifyVariableOperationAsserts(3, "SetVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddTaskVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable1", (Object)"THIS IS TESTVARIABLE!!!");
        this.verifyVariableOperationAsserts(1, "SetVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddTaskVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariables(this.processTaskId, this.createMapForVariableAddition());
        this.verifyVariableOperationAsserts(1, "SetVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddTaskVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable3", (Object)"foo");
        this.taskService.setVariables(this.processTaskId, this.createMapForVariableAddition());
        this.taskService.setVariable(this.processTaskId, "testVariable4", (Object)"bar");
        this.verifyVariableOperationAsserts(3, "SetVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchExecutionVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(this.process.getId(), this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "ModifyVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchTaskVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.processTaskId, this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "ModifyVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveExecutionVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariable(this.process.getId(), "testVariable1");
        this.verifyVariableOperationAsserts(1, "RemoveVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveExecutionVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariables(this.process.getId(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "RemoveVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveExecutionVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariable(this.process.getId(), "testVariable1");
        this.runtimeService.removeVariables(this.process.getId(), this.createCollectionForVariableDeletion());
        this.runtimeService.removeVariable(this.process.getId(), "testVariable2");
        this.verifyVariableOperationAsserts(3, "RemoveVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveTaskVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.removeVariable(this.processTaskId, "testVariable1");
        this.verifyVariableOperationAsserts(1, "RemoveVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveTaskVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.removeVariables(this.processTaskId, this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "RemoveVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveTaskVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.removeVariable(this.processTaskId, "testVariable3");
        this.taskService.removeVariables(this.processTaskId, this.createCollectionForVariableDeletion());
        this.taskService.removeVariable(this.processTaskId, "testVariable4");
        this.verifyVariableOperationAsserts(3, "RemoveVariable");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseInstanceId(caseInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        UserOperationLogQueryTest.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseExecutionId(caseExecutionId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDeploymentId() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(ONE_TASK_PROCESS).deploy().getId();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().deploymentId(deploymentId);
        this.verifyQueryResults(query, 1);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testQueryByInvalidDeploymentId() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.deploymentId(null);
            UserOperationLogQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private void verifyQueryResults(UserOperationLogQuery query, int countExpected) {
        UserOperationLogQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        UserOperationLogQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            UserOperationLogQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            UserOperationLogQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(UserOperationLogQuery query) {
        try {
            query.singleResult();
            UserOperationLogQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private Map<String, Object> createMapForVariableAddition() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("testVariable1", "THIS IS TESTVARIABLE!!!");
        variables.put("testVariable2", "OVER 9000!");
        return variables;
    }

    private Collection<String> createCollectionForVariableDeletion() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("testVariable3");
        variables.add("testVariable4");
        return variables;
    }

    private void verifyVariableOperationAsserts(int countAssertValue, String operationType) {
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        UserOperationLogQueryTest.assertEquals((long)countAssertValue, (long)logQuery.count());
        if (countAssertValue > 1) {
            List logEntryList = logQuery.list();
            for (UserOperationLogEntry logEntry : logEntryList) {
                UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)logEntry.getProcessDefinitionId());
                UserOperationLogQueryTest.assertEquals((String)this.process.getProcessInstanceId(), (String)logEntry.getProcessInstanceId());
                UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)logEntry.getDeploymentId());
            }
        } else {
            UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
            UserOperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)logEntry.getProcessDefinitionId());
            UserOperationLogQueryTest.assertEquals((String)this.process.getProcessInstanceId(), (String)logEntry.getProcessInstanceId());
            UserOperationLogQueryTest.assertEquals((String)this.deploymentId, (String)logEntry.getDeploymentId());
        }
    }

    private UserOperationLogQuery query() {
        return this.historyService.createUserOperationLogQuery();
    }

    private void createLogEntries() {
        ClockUtil.setCurrentTime((Date)this.yesterday);
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.execution = (Execution)this.processEngine.getRuntimeService().createExecutionQuery().processInstanceId(this.process.getId()).singleResult();
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("icke");
        this.taskService.addCandidateUser(this.processTaskId, "er");
        this.taskService.deleteCandidateUser(this.processTaskId, "er");
        this.taskService.addCandidateGroup(this.processTaskId, "wir");
        this.taskService.deleteCandidateGroup(this.processTaskId, "wir");
        ClockUtil.setCurrentTime((Date)this.today);
        this.taskService.setOwner(this.processTaskId, "icke");
        this.taskService.claim(this.processTaskId, "icke");
        this.taskService.setAssignee(this.processTaskId, "er");
        this.taskService.setPriority(this.processTaskId, 10);
        Attachment attachment = this.taskService.createAttachment("image/ico", this.processTaskId, this.process.getId(), "favicon.ico", "favicon", "http://camunda.com/favicon.ico");
        this.taskService.deleteAttachment(attachment.getId());
        this.taskService.complete(this.processTaskId);
        this.assertProcessEnded(this.process.getId());
        this.identityService.setAuthenticatedUserId("er");
        this.userTask = this.taskService.newTask();
        this.userTask.setName("to do");
        this.taskService.saveTask(this.userTask);
        ClockUtil.setCurrentTime((Date)this.tomorrow);
        this.userTask.setDescription("desc");
        this.userTask.setOwner("icke");
        this.userTask.setAssignee("er");
        this.userTask.setDueDate(new Date());
        this.taskService.saveTask(this.userTask);
        this.taskService.complete(this.userTask.getId());
    }
}

