/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;

public class JobAcquisitionTest
extends PluggableProcessEngineTestCase {
    protected static final int DEFAULT_NUM_JOBS_TO_ACQUIRE = 3;
    protected ControllableJobExecutor jobExecutor1;
    protected ControllableJobExecutor jobExecutor2;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread1;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread2;

    protected void setUp() throws Exception {
        this.jobExecutor1 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        this.jobExecutor1.setMaxJobsPerAcquisition(3);
        this.acquisitionThread1 = this.jobExecutor1.getAcquisitionThreadControl();
        this.jobExecutor2 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        this.jobExecutor2.setMaxJobsPerAcquisition(3);
        this.acquisitionThread2 = this.jobExecutor2.getAcquisitionThreadControl();
    }

    protected void tearDown() throws Exception {
        this.jobExecutor1.shutdown();
        this.jobExecutor2.shutdown();
        super.tearDown();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testJobLockingFailure() {
        int numberOfInstances = 3;
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess").getId();
        }
        this.jobExecutor1.start();
        this.acquisitionThread1.waitForSync();
        this.jobExecutor2.start();
        this.acquisitionThread2.waitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        JobAcquisitionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().active().count());
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor1WaitEvents = this.jobExecutor1.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionTest.assertEquals((int)1, (int)jobExecutor1WaitEvents.size());
        JobAcquisitionTest.assertEquals((long)0L, (long)jobExecutor1WaitEvents.get(0).getTimeBetweenAcquisitions());
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionTest.assertEquals((int)1, (int)jobExecutor2WaitEvents.size());
        JobAcquisitionTest.assertEquals((long)0L, (long)jobExecutor2WaitEvents.get(0).getTimeBetweenAcquisitions());
    }
}

