/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;

public class JobExecutorAcquireJobsByPriorityTest
extends AbstractJobExecutorAcquireJobsTest {
    protected boolean defaultAcquireByPriority = false;

    @Override
    protected boolean isJobExecutorAcquireByPriority() {
        return true;
    }

    public void testProcessEngineConfiguration() {
        ProcessEngineConfigurationImpl configuration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        JobExecutorAcquireJobsByPriorityTest.assertFalse((boolean)configuration.isJobExecutorPreferTimerJobs());
        JobExecutorAcquireJobsByPriorityTest.assertFalse((boolean)configuration.isJobExecutorAcquireByDueDate());
        JobExecutorAcquireJobsByPriorityTest.assertTrue((boolean)configuration.isJobExecutorAcquireByPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobPrioProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/timerJobPrioProcess.bpmn20.xml"})
    public void testAcquisitionByPriority() {
        int i;
        this.startProcess("jobPrioProcess", "task1", 5);
        this.startProcess("jobPrioProcess", "task2", 5);
        this.startProcess("timerJobPrioProcess", "timer1", 5);
        this.startProcess("timerJobPrioProcess", "timer2", 5);
        this.incrementClock(61L);
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        JobExecutorAcquireJobsByPriorityTest.assertEquals((int)20, (int)acquirableJobs.size());
        for (i = 0; i < 5; ++i) {
            JobExecutorAcquireJobsByPriorityTest.assertEquals((long)10L, (long)acquirableJobs.get(i).getPriority());
        }
        for (i = 5; i < 10; ++i) {
            JobExecutorAcquireJobsByPriorityTest.assertEquals((long)8L, (long)acquirableJobs.get(i).getPriority());
        }
        for (i = 10; i < 15; ++i) {
            JobExecutorAcquireJobsByPriorityTest.assertEquals((long)5L, (long)acquirableJobs.get(i).getPriority());
        }
        for (i = 15; i < 20; ++i) {
            JobExecutorAcquireJobsByPriorityTest.assertEquals((long)4L, (long)acquirableJobs.get(i).getPriority());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobPrioProcess.bpmn20.xml"})
    public void testMixedPriorityAcquisition() {
        this.startProcess("jobPrioProcess", "task1", 5);
        this.startProcess("jobPrioProcess", "task2", 5);
    }
}

