/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.pvm;

import java.util.ArrayList;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionImpl;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.pvm.ActivityInstanceVerification;
import org.camunda.bpm.engine.test.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.pvm.activities.EmbeddedSubProcess;
import org.camunda.bpm.engine.test.pvm.activities.End;
import org.camunda.bpm.engine.test.pvm.activities.ParallelGateway;
import org.camunda.bpm.engine.test.pvm.activities.WaitState;
import org.camunda.bpm.engine.test.pvm.activities.While;
import org.camunda.bpm.engine.test.pvm.verification.TransitionInstanceVerifyer;

public class PvmActivityInstanceTest
extends PvmTestCase {
    public void testSequence() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("one").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("two").endActivity().createActivity("two").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("three").endActivity().createActivity("three").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        verifier.assertStartInstanceCount(1, "one");
        verifier.assertStartInstanceCount(1, "two");
        verifier.assertStartInstanceCount(1, "three");
    }

    public void testWhileLoop() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        TransitionInstanceVerifyer transitionVerifier = new TransitionInstanceVerifyer();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).startTransition("loop").executionListener("take", (ExecutionListener)transitionVerifier).endTransition().endActivity().createActivity("loop").behavior((ActivityBehavior)new While("count", 0, 10)).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).startTransition("one", "more").executionListener("take", (ExecutionListener)transitionVerifier).endTransition().startTransition("end", "done").executionListener("take", (ExecutionListener)transitionVerifier).endTransition().endActivity().createActivity("one").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("two").endActivity().createActivity("two").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("three").endActivity().createActivity("three").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("loop").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmActivityInstanceTest.assertEquals(new ArrayList(), (Object)processInstance.findActiveActivityIds());
        PvmActivityInstanceTest.assertTrue((boolean)processInstance.isEnded());
        verifier.assertStartInstanceCount(1, "start");
        verifier.assertProcessInstanceParent("start", processInstance);
        verifier.assertStartInstanceCount(11, "loop");
        verifier.assertProcessInstanceParent("loop", processInstance);
        verifier.assertStartInstanceCount(10, "one");
        verifier.assertProcessInstanceParent("one", processInstance);
        verifier.assertStartInstanceCount(10, "two");
        verifier.assertProcessInstanceParent("two", processInstance);
        verifier.assertStartInstanceCount(10, "three");
        verifier.assertProcessInstanceParent("three", processInstance);
        verifier.assertStartInstanceCount(1, "end");
        verifier.assertProcessInstanceParent("end", processInstance);
    }

    public void testMultipleConcurrentEndsInsideEmbeddedSubProcessWithWaitState() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("endInside1").transition("wait").transition("endInside3").endActivity().createActivity("endInside1").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().createActivity("wait").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("endInside2").endActivity().createActivity("endInside2").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().createActivity("endInside3").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmActivityInstanceTest.assertFalse((boolean)processInstance.isEnded());
        PvmExecution execution = processInstance.findExecution("wait");
        execution.signal(null, null);
        PvmActivityInstanceTest.assertTrue((boolean)processInstance.isEnded());
        verifier.assertStartInstanceCount(1, "start");
        verifier.assertProcessInstanceParent("start", processInstance);
        verifier.assertStartInstanceCount(1, "embeddedsubprocess");
        verifier.assertProcessInstanceParent("embeddedsubprocess", processInstance);
        verifier.assertStartInstanceCount(1, "startInside");
        verifier.assertParent("startInside", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "fork");
        verifier.assertParent("fork", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "wait");
        verifier.assertParent("wait", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "endInside1");
        verifier.assertParent("endInside1", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "endInside2");
        verifier.assertParent("endInside2", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "endInside3");
        verifier.assertParent("endInside3", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "end");
        verifier.assertProcessInstanceParent("end", processInstance);
    }

    public void testNestedSubProcessNoEnd() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("nestedSubProcess").endActivity().createActivity("nestedSubProcess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("startNestedInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmActivityInstanceTest.assertTrue((boolean)processInstance.isEnded());
        verifier.assertStartInstanceCount(1, "start");
        verifier.assertProcessInstanceParent("start", processInstance);
        verifier.assertStartInstanceCount(1, "embeddedsubprocess");
        verifier.assertProcessInstanceParent("embeddedsubprocess", processInstance);
        verifier.assertStartInstanceCount(1, "startInside");
        verifier.assertParent("startInside", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "nestedSubProcess");
        verifier.assertParent("nestedSubProcess", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "startNestedInside");
        verifier.assertParent("startNestedInside", "nestedSubProcess");
        verifier.assertStartInstanceCount(1, "endInside");
        verifier.assertParent("endInside", "nestedSubProcess");
        verifier.assertStartInstanceCount(1, "end");
        verifier.assertProcessInstanceParent("end", processInstance);
    }

    public void testNestedSubProcessBothNoEnd() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("nestedSubProcess").endActivity().createActivity("nestedSubProcess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("startNestedInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().endActivity().endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmActivityInstanceTest.assertTrue((boolean)processInstance.isEnded());
        verifier.assertStartInstanceCount(1, "start");
        verifier.assertProcessInstanceParent("start", processInstance);
        verifier.assertStartInstanceCount(1, "embeddedsubprocess");
        verifier.assertProcessInstanceParent("embeddedsubprocess", processInstance);
        verifier.assertStartInstanceCount(1, "startInside");
        verifier.assertParent("startInside", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "nestedSubProcess");
        verifier.assertParent("nestedSubProcess", "embeddedsubprocess");
        verifier.assertStartInstanceCount(1, "startNestedInside");
        verifier.assertParent("startNestedInside", "nestedSubProcess");
    }

    public void testSubProcessNoEnd() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().endActivity().executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmActivityInstanceTest.assertTrue((boolean)processInstance.isEnded());
        verifier.assertStartInstanceCount(1, "start");
        verifier.assertProcessInstanceParent("start", processInstance);
        verifier.assertStartInstanceCount(1, "embeddedsubprocess");
        verifier.assertProcessInstanceParent("embeddedsubprocess", processInstance);
        verifier.assertStartInstanceCount(1, "startInside");
        verifier.assertStartInstanceCount(1, "startInside");
    }

    public void testStartInSubProcess() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().transition("end").endActivity().executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = ((ProcessDefinitionImpl)processDefinition).createProcessInstanceForInitial((ActivityImpl)processDefinition.findActivity("endInside"));
        processInstance.start();
        PvmActivityInstanceTest.assertTrue((boolean)processInstance.isEnded());
        verifier.assertStartInstanceCount(0, "start");
        verifier.assertStartInstanceCount(1, "embeddedsubprocess");
        verifier.assertProcessInstanceParent("embeddedsubprocess", processInstance);
        verifier.assertStartInstanceCount(0, "startInside");
        verifier.assertIsCompletingActivityInstance("endInside", 1);
        verifier.assertStartInstanceCount(1, "end");
    }

    public void testScopeActivity() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("one").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("two").endActivity().createActivity("two").scope().behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).transition("three").endActivity().createActivity("three").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)verifier).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmExecution childExecution = processInstance.findExecution("two");
        String parentActivityInstanceId = ((ExecutionImpl)childExecution).getParentActivityInstanceId();
        PvmActivityInstanceTest.assertEquals((String)((ExecutionImpl)processInstance).getId(), (String)parentActivityInstanceId);
        childExecution.signal(null, null);
        verifier.assertStartInstanceCount(1, "one");
        verifier.assertStartInstanceCount(1, "two");
        verifier.assertProcessInstanceParent("two", processInstance);
        verifier.assertStartInstanceCount(1, "three");
    }
}

