/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CompareUtilTest {
    @Test
    public void testDateNotInAnAscendingOrder() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2015, 2, 15);
        Date first = calendar.getTime();
        calendar.set(2015, 7, 15);
        Date second = calendar.getTime();
        Object nullDate = null;
        Assert.assertThat((Object)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{null, first, null, second}), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{null, first, null, first}), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{null, second, null, first}), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{nullDate, nullDate, nullDate}), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.areNotInAscendingOrder(Arrays.asList(first, second)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.areNotInAscendingOrder(Arrays.asList(first, first)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.areNotInAscendingOrder(Arrays.asList(second, first)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsNotContainedIn() {
        String element = "test";
        Object[] values = new String[]{"test", "test1", "test2"};
        Object[] values2 = new String[]{"test1", "test2"};
        Object[] nullValues = null;
        Collection nullList = null;
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInArray((Object)element, (Object[])values), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInArray((Object)element, (Object[])values2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInArray(null, (Object[])values), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInArray(null, nullValues), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInArray((Object)element, nullValues), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInList((Object)element, Arrays.asList(values)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInList((Object)element, Arrays.asList(values2)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInList(null, Arrays.asList(values)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInList(null, nullList), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsNotContainedInList((Object)element, nullList), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsContainedIn() {
        String element = "test";
        Object[] values = new String[]{"test", "test1", "test2"};
        Object[] values2 = new String[]{"test1", "test2"};
        Object[] nullValues = null;
        Collection nullList = null;
        Assert.assertThat((Object)CompareUtil.elementIsContainedInArray((Object)element, (Object[])values), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInArray((Object)element, (Object[])values2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInArray(null, (Object[])values), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInArray(null, nullValues), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInArray((Object)element, nullValues), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInList((Object)element, Arrays.asList(values)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInList((Object)element, Arrays.asList(values2)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInList(null, Arrays.asList(values)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInList(null, nullList), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)CompareUtil.elementIsContainedInList((Object)element, nullList), (Matcher)Matchers.is((Object)false));
    }
}

