/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.junit.Assert;

public class ExecutionTreeAssertion {
    protected String expectedActivityId;
    protected Boolean expectedIsScope = true;
    protected Boolean expectedIsConcurrent = false;
    protected Boolean expectedIsEventScope = false;
    protected List<ExecutionTreeAssertion> childAssertions = new ArrayList<ExecutionTreeAssertion>();

    public void addChildAssertion(ExecutionTreeAssertion childAssertion) {
        this.childAssertions.add(childAssertion);
    }

    public void setExpectedActivityId(String expectedActivityId) {
        this.expectedActivityId = expectedActivityId;
    }

    protected boolean matches(ExecutionTree tree) {
        String actualActivityId = tree.getActivityId();
        if (this.expectedActivityId == null && actualActivityId != null) {
            return false;
        }
        if (this.expectedActivityId != null && !this.expectedActivityId.equals(tree.getActivityId())) {
            return false;
        }
        if (this.expectedIsScope != null && !this.expectedIsScope.equals(tree.isScope())) {
            return false;
        }
        if (this.expectedIsConcurrent != null && !this.expectedIsConcurrent.equals(tree.isConcurrent())) {
            return false;
        }
        if (this.expectedIsEventScope != null && !this.expectedIsEventScope.equals(tree.isEventScope())) {
            return false;
        }
        if (tree.getExecutions().size() != this.childAssertions.size()) {
            return false;
        }
        ArrayList<ExecutionTreeAssertion> unmatchedChildAssertions = new ArrayList<ExecutionTreeAssertion>(this.childAssertions);
        block0: for (ExecutionTree child : tree.getExecutions()) {
            for (ExecutionTreeAssertion childAssertion : unmatchedChildAssertions) {
                if (!childAssertion.matches(child)) continue;
                unmatchedChildAssertions.remove(childAssertion);
                continue block0;
            }
        }
        return unmatchedChildAssertions.isEmpty();
    }

    public void assertExecution(ExecutionTree tree) {
        boolean matches = this.matches(tree);
        if (!matches) {
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("Expected tree: \n");
            ExecutionTreeAssertion.describe(this, "", errorBuilder);
            errorBuilder.append("Actual tree: \n");
            ExecutionTreeAssertion.describe(tree, "", errorBuilder);
            Assert.fail((String)errorBuilder.toString());
        }
    }

    public static void describe(ExecutionTree tree, String prefix, StringBuilder errorBuilder) {
        errorBuilder.append(prefix);
        errorBuilder.append(ExecutionTreeAssertion.executionTreeToString(tree));
        errorBuilder.append("\n");
        for (ExecutionTree child : tree.getExecutions()) {
            ExecutionTreeAssertion.describe(child, prefix + "   ", errorBuilder);
        }
    }

    public static void describe(ExecutionTreeAssertion assertion, String prefix, StringBuilder errorBuilder) {
        errorBuilder.append(prefix);
        errorBuilder.append(assertion);
        errorBuilder.append("\n");
        for (ExecutionTreeAssertion child : assertion.childAssertions) {
            ExecutionTreeAssertion.describe(child, prefix + "   ", errorBuilder);
        }
    }

    public static String executionTreeToString(ExecutionTree executionTree) {
        StringBuilder sb = new StringBuilder();
        sb.append(executionTree.getExecution());
        sb.append("[activityId=");
        sb.append(executionTree.getActivityId());
        sb.append(", isScope=");
        sb.append(executionTree.isScope());
        sb.append(", isConcurrent=");
        sb.append(executionTree.isConcurrent());
        sb.append(", isEventScope=");
        sb.append(executionTree.isEventScope());
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[activityId=");
        sb.append(this.expectedActivityId);
        if (this.expectedIsScope != null) {
            sb.append(", isScope=");
            sb.append(this.expectedIsScope);
        }
        if (this.expectedIsConcurrent != null) {
            sb.append(", isConcurrent=");
            sb.append(this.expectedIsConcurrent);
        }
        if (this.expectedIsEventScope != null) {
            sb.append(", isEventScope=");
            sb.append(this.expectedIsEventScope);
        }
        sb.append("]");
        return sb.toString();
    }

    public void setExpectedIsScope(Boolean expectedIsScope) {
        this.expectedIsScope = expectedIsScope;
    }

    public void setExpectedIsConcurrent(Boolean expectedIsConcurrent) {
        this.expectedIsConcurrent = expectedIsConcurrent;
    }

    public void setExpectedIsEventScope(Boolean expectedIsEventScope) {
        this.expectedIsEventScope = expectedIsEventScope;
    }
}

