/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.RemoveAndUpdateValueDelegate;
import org.camunda.bpm.engine.test.history.ReplaceAndUpdateValueDelegate;
import org.camunda.bpm.engine.test.history.UpdateValueDelegate;
import org.camunda.bpm.engine.variable.Variables;

public class ImplicitVariableUpdateTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    public void testUpdate() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        ImplicitVariableUpdateTest.assertNotNull((Object)list);
        ImplicitVariableUpdateTest.assertEquals((int)1, (int)list.size());
        ImplicitVariableUpdateTest.assertEquals((String)"new element", (String)((String)list.get(0)));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/ImplicitVariableUpdateTest.parallel.bpmn20.xml"})
    public void testUpdateParallelFlow() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        ImplicitVariableUpdateTest.assertNotNull((Object)list);
        ImplicitVariableUpdateTest.assertEquals((int)1, (int)list.size());
        ImplicitVariableUpdateTest.assertEquals((String)"new element", (String)((String)list.get(0)));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    public void testUpdatePreviousValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new ReplaceAndUpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        ImplicitVariableUpdateTest.assertNotNull((Object)list);
        ImplicitVariableUpdateTest.assertTrue((boolean)list.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    public void testRemoveAndUpdateValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new RemoveAndUpdateValueDelegate()));
        Object variableValue = this.runtimeService.getVariable(instance.getId(), "listVar");
        ImplicitVariableUpdateTest.assertNull((Object)variableValue);
    }
}

