/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.PreUndeploy;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.deployment.util.InjectionUtil;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;

public class PreUndeployInvocationStep
extends DeploymentOperationStep {
    private static final String CALLBACK_NAME = "@PreUndeploy";
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Invoking @PreUndeploy";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        String paName = processApplication.getName();
        Class<?> paClass = processApplication.getClass();
        Method preUndeployMethod = InjectionUtil.detectAnnotatedMethod(paClass, PreUndeploy.class);
        if (preUndeployMethod == null) {
            LOG.debugPaLifecycleMethodNotFound(CALLBACK_NAME, paName);
            return;
        }
        LOG.debugFoundPaLifecycleCallbackMethod(CALLBACK_NAME, paName);
        Object[] injections = InjectionUtil.resolveInjections(operationContext, preUndeployMethod);
        try {
            preUndeployMethod.invoke((Object)processApplication, injections);
        }
        catch (IllegalArgumentException e) {
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
        catch (IllegalAccessException e) {
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
    }
}

