/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.repository;

import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.repository.CaseDefinition;

public class CaseDefinitionEntity
extends CmmnCaseDefinition
implements CaseDefinition,
ResourceDefinitionEntity,
DbEntity,
HasDbRevision {
    private static final long serialVersionUID = 1L;
    protected int revision = 1;
    protected String category;
    protected String key;
    protected int version;
    protected String deploymentId;
    protected String resourceName;
    protected String diagramResourceName;
    protected Map<String, TaskDefinition> taskDefinitions;
    protected boolean firstVersion = false;
    protected String previousCaseDefinitionId;

    public CaseDefinitionEntity() {
        super(null);
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
        this.firstVersion = this.version == 1;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String getDiagramResourceName() {
        return this.diagramResourceName;
    }

    @Override
    public void setDiagramResourceName(String diagramResourceName) {
        this.diagramResourceName = diagramResourceName;
    }

    public Map<String, TaskDefinition> getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public void setTaskDefinitions(Map<String, TaskDefinition> taskDefinitions) {
        this.taskDefinitions = taskDefinitions;
    }

    @Override
    public CaseDefinitionEntity getPreviousDefinition() {
        CaseDefinitionEntity previousCaseDefinition = null;
        String previousCaseDefinitionId = this.getPreviousCaseDefinitionId();
        if (previousCaseDefinitionId != null && (previousCaseDefinition = this.loadCaseDefinition(previousCaseDefinitionId)) == null) {
            this.resetPreviousCaseDefinitionId();
            previousCaseDefinitionId = this.getPreviousCaseDefinitionId();
            if (previousCaseDefinitionId != null) {
                previousCaseDefinition = this.loadCaseDefinition(previousCaseDefinitionId);
            }
        }
        return previousCaseDefinition;
    }

    protected CaseDefinitionEntity loadCaseDefinition(String caseDefinitionId) {
        CommandContext commandContext;
        CaseDefinitionManager caseDefinitionManager;
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        CaseDefinitionEntity caseDefinition = deploymentCache.findCaseDefinitionFromCache(caseDefinitionId);
        if (caseDefinition == null && (caseDefinition = (caseDefinitionManager = (commandContext = Context.getCommandContext()).getCaseDefinitionManager()).findCaseDefinitionById(caseDefinitionId)) != null) {
            caseDefinition = deploymentCache.resolveCaseDefinition(caseDefinition);
        }
        return caseDefinition;
    }

    protected String getPreviousCaseDefinitionId() {
        this.ensurePreviousCaseDefinitionIdInitialized();
        return this.previousCaseDefinitionId;
    }

    protected void setPreviousCaseDefinitionId(String previousCaseDefinitionId) {
        this.previousCaseDefinitionId = previousCaseDefinitionId;
    }

    protected void resetPreviousCaseDefinitionId() {
        this.previousCaseDefinitionId = null;
        this.ensurePreviousCaseDefinitionIdInitialized();
    }

    protected void ensurePreviousCaseDefinitionIdInitialized() {
        if (this.previousCaseDefinitionId == null && !this.firstVersion) {
            this.previousCaseDefinitionId = Context.getCommandContext().getCaseDefinitionManager().findPreviousCaseDefinitionIdByKeyAndVersion(this.key, this.version);
            if (this.previousCaseDefinitionId == null) {
                this.firstVersion = true;
            }
        }
    }

    @Override
    protected CmmnExecution newCaseInstance() {
        CaseExecutionEntity caseInstance = new CaseExecutionEntity();
        Context.getCommandContext().getCaseExecutionManager().insertCaseExecution(caseInstance);
        return caseInstance;
    }

    @Override
    public Object getPersistentState() {
        return CaseDefinitionEntity.class;
    }

    @Override
    public String toString() {
        return "CaseDefinitionEntity[" + this.id + "]";
    }
}

