/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteCommandDelegate;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteCommandListener;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteCommandTaskListener;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteQueryDelegate;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteQueryListener;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteQueryTaskListener;
import org.camunda.bpm.engine.test.api.authorization.service.MyDelegationService;
import org.camunda.bpm.engine.test.api.authorization.service.MyFormFieldValidator;
import org.camunda.bpm.engine.test.api.authorization.service.MyServiceTaskActivityBehaviorExecuteCommand;
import org.camunda.bpm.engine.test.api.authorization.service.MyServiceTaskActivityBehaviorExecuteQuery;
import org.camunda.bpm.engine.test.api.authorization.service.MyTaskService;

public class DelegationAuthorizationTest
extends AuthorizationTest {
    public static final String DEFAULT_PROCESS_KEY = "process";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MyDelegationService.clearProperties();
        this.processEngineConfiguration.setAuthorizationEnabledForCustomCode(false);
    }

    @Deployment
    public void testJavaDelegateExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testJavaDelegateExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testJavaDelegateExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteQueryDelegate());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testJavaDelegateExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteCommandDelegate());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testJavaDelegateExecutesQueryAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteQueryDelegate());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testJavaDelegateExecutesCommandAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteCommandDelegate());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testCustomActivityBehaviorExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testCustomActivityBehaviorExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testCustomActivityBehaviorExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myBehavior", new MyServiceTaskActivityBehaviorExecuteQuery());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testCustomActivityBehaviorExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myBehavior", new MyServiceTaskActivityBehaviorExecuteCommand());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testSignallableActivityBehaviorAsClass() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 4);
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testSignallableActivityBehaviorAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("activityBehavior", new MyServiceTaskActivityBehaviorExecuteQuery());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 4);
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testExecutionListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testExecutionListenerExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testExecutionListenerExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testExecutionListenerExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testExecutionListenerExecutesQueryAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testExecutionListenerExecutesCommandAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testTaskListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testTaskListenerExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testTaskListenerExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryTaskListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testTaskListenerExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandTaskListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testTaskListenerExecutesQueryAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryTaskListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testTaskListenerExecutesCommandAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandTaskListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testTaskAssigneeExpression() {
        this.processEngineConfiguration.getBeans().put("myTaskService", new MyTaskService());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testScriptTaskExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableCount);
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptTaskExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptExecutionListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableCount);
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptExecutionListenerExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptTaskListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableCount);
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptTaskListenerExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptConditionExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableCount);
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptConditionExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptIoMappingExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableCount);
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    public void testScriptIoMappingExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableUser);
        DelegationAuthorizationTest.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)variableCount);
        DelegationAuthorizationTest.assertEquals((Object)1L, (Object)variableCount.getValue());
        DelegationAuthorizationTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testCustomStartFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String processDefinitionId = this.selectProcessDefinitionByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, DEFAULT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        StartFormData startFormData = this.formService.getStartFormData(processDefinitionId);
        DelegationAuthorizationTest.assertNotNull((Object)startFormData);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testCustomTaskFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)taskFormData);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testCustomStartFormHandlerExecutesQuery.bpmn20.xml"})
    public void testSubmitCustomStartFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String processDefinitionId = this.selectProcessDefinitionByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, DEFAULT_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.formService.submitStartForm(processDefinitionId, null);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testCustomTaskFormHandlerExecutesQuery.bpmn20.xml"})
    public void testSubmitCustomTaskFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testCustomFormFieldValidator() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    public void testCustomFormFieldValidatorAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myValidator", new MyFormFieldValidator());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testJavaDelegateExecutesQueryAfterUserCompletesTask.bpmn20.xml"})
    public void testPerformAuthorizationCheckByExecutingQuery() {
        this.processEngineConfiguration.setAuthorizationEnabledForCustomCode(true);
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        DelegationAuthorizationTest.assertEquals((Object)0L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testJavaDelegateExecutesCommandAfterUserCompletesTask.bpmn20.xml"})
    public void testPerformAuthorizationCheckByExecutingCommand() {
        this.processEngineConfiguration.setAuthorizationEnabledForCustomCode(true);
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.complete(taskId);
            DelegationAuthorizationTest.fail((String)"Exception expected: It should not be possible to execute the command inside JavaDelegate");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        DelegationAuthorizationTest.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        DelegationAuthorizationTest.assertEquals((String)this.userId, (String)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        DelegationAuthorizationTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    public void testTaskListenerOnCreateAssignsTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        DelegationAuthorizationTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    protected void startProcessInstancesByKey(String key, int count) {
        for (int i = 0; i < count; ++i) {
            this.startProcessInstanceByKey(key);
        }
    }

    protected Task selectAnyTask() {
        this.disableAuthorization();
        Task task = (Task)this.taskService.createTaskQuery().listPage(0, 1).get(0);
        this.enableAuthorization();
        return task;
    }
}

