/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.deployment;

import java.util.Collection;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RedeployDeploymentAuthorizationTest {
    public ProcessEngineRule engineRule = new ProcessEngineRule(PluggableProcessEngineTestCase.getProcessEngine(), true);
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DEPLOYMENT, "*", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DEPLOYMENT, "*", "userId", new Permission[]{Permissions.CREATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DEPLOYMENT, "deploymentId", "userId", new Permission[]{Permissions.READ})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DEPLOYMENT, "deploymentId", "userId", new Permission[]{Permissions.READ}), AuthorizationSpec.grant((Resource)Resources.DEPLOYMENT, "*", "userId", new Permission[]{Permissions.CREATE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    public void testRedeploy() {
        RepositoryService repositoryService = this.engineRule.getRepositoryService();
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        Deployment deployment1 = repositoryService.createDeployment().addModelInstance("process1.bpmn", model1).addModelInstance("process2.bpmn", model2).deploy();
        this.authRule.init(this.scenario).withUser("userId").bindResource("deploymentId", deployment1.getId()).start();
        Deployment deployment2 = repositoryService.createDeployment().addDeploymentResources(deployment1.getId()).deploy();
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)2L, (long)repositoryService.createDeploymentQuery().count());
            this.deleteDeployments(deployment2);
            this.deleteAuthorizations();
        }
        this.deleteDeployments(deployment1);
    }

    protected void deleteDeployments(Deployment ... deployments) {
        for (Deployment deployment : deployments) {
            this.engineRule.getRepositoryService().deleteDeployment(deployment.getId(), true);
        }
    }

    protected void deleteAuthorizations() {
        AuthorizationService authorizationService = this.engineRule.getAuthorizationService();
        for (Authorization authorization : authorizationService.createAuthorizationQuery().list()) {
            authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

