/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.jobdefinition;

import java.util.Collection;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SetJobDefinitionPriorityAuthorizationTest {
    public ProcessEngineRule engineRule = new ProcessEngineRule(PluggableProcessEngineTestCase.getProcessEngine(), true);
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.UPDATE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml"})
    public void testSetJobDefinitionPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().singleResult();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processDefinitionKey", "process").start();
        this.engineRule.getManagementService().setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        if (this.authRule.assertScenario(this.scenario)) {
            JobDefinition updatedJobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().singleResult();
            Assert.assertEquals((long)42L, (long)updatedJobDefinition.getOverridingJobPriority());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml"})
    public void testResetJobDefinitionPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().singleResult();
        this.engineRule.getManagementService().setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processDefinitionKey", "process").start();
        this.engineRule.getManagementService().clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        if (this.authRule.assertScenario(this.scenario)) {
            JobDefinition updatedJobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().singleResult();
            Assert.assertNull((Object)updatedJobDefinition.getOverridingJobPriority());
        }
    }
}

