/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.AssertUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.joda.time.DateTime;

public class ExternalTaskServiceTest
extends PluggableProcessEngineTestCase {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final long LOCK_TIME = 10000L;
    protected static final String TOPIC_NAME = "externalTaskTopic";

    protected void setUp() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
    }

    protected void tearDown() throws Exception {
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetch() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        ExternalTaskServiceTest.assertNotNull((Object)task.getId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getId(), (String)task.getProcessInstanceId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)task.getProcessDefinitionId());
        ExternalTaskServiceTest.assertEquals((String)"externalTask", (String)task.getActivityId());
        ExternalTaskServiceTest.assertEquals((String)"oneExternalTaskProcess", (String)task.getProcessDefinitionKey());
        ExternalTaskServiceTest.assertEquals((String)TOPIC_NAME, (String)task.getTopicName());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("externalTask")[0];
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getId(), (String)task.getActivityInstanceId());
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getExecutionIds()[0], (String)task.getExecutionId());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        ExternalTaskServiceTest.assertEquals((String)WORKER_ID, (String)task.getWorkerId());
    }

    @Deployment
    public void testFetchTopicSelection() {
        this.runtimeService.startProcessInstanceByKey("twoTopicsProcess");
        List topic1Tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).execute();
        List topic2Tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic2", 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)topic1Tasks.size());
        ExternalTaskServiceTest.assertEquals((String)"topic1", (String)((LockedExternalTask)topic1Tasks.get(0)).getTopicName());
        ExternalTaskServiceTest.assertEquals((int)1, (int)topic2Tasks.size());
        ExternalTaskServiceTest.assertEquals((String)"topic2", (String)((LockedExternalTask)topic2Tasks.get(0)).getTopicName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchWithoutTopicName() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(null, 10000L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("topicName is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, null).topic(TOPIC_NAME, 10000L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNegativeNumberOfTasks() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(-1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("maxResults is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchLessTasksThanExist() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        }
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)5, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNegativeLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, -1L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("lockTime is not greater than 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchZeroLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 0L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("lockTime is not greater than 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNoTopics() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
    }

    @Deployment
    public void testFetchVariables() {
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"processVar1", "subProcessVar", "taskVar"}).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        VariableMap variables = task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)3, (int)variables.size());
        ExternalTaskServiceTest.assertEquals((Object)42, (Object)variables.get((Object)"processVar1"));
        ExternalTaskServiceTest.assertEquals((Object)44L, (Object)variables.get((Object)"subProcessVar"));
        ExternalTaskServiceTest.assertEquals((Object)45L, (Object)variables.get((Object)"taskVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNonExistingVariable() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"nonExistingVariable"}).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ExternalTaskServiceTest.assertTrue((boolean)task.getVariables().isEmpty());
    }

    @Deployment
    public void testFetchMultipleTopics() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 20000L).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)tasks.size());
        LockedExternalTask topic1Task = "topic1".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        LockedExternalTask topic2Task = "topic2".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        ExternalTaskServiceTest.assertEquals((String)"topic1", (String)topic1Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), topic1Task.getLockExpirationTime());
        ExternalTaskServiceTest.assertEquals((String)"topic2", (String)topic2Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(20000L), topic2Task.getLockExpirationTime());
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 20000L).topic("topic3", 30000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)tasks.size());
        LockedExternalTask topic3Task = (LockedExternalTask)tasks.get(0);
        ExternalTaskServiceTest.assertEquals((String)"topic3", (String)topic3Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(30000L), topic3Task.getLockExpirationTime());
    }

    @Deployment
    public void testFetchMultipleTopicsWithVariables() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", (Map)Variables.createVariables().putValue("var1", (Object)0).putValue("var2", (Object)0));
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).variables(new String[]{"var1", "var2"}).topic("topic2", 10000L).variables(new String[]{"var1"}).execute();
        LockedExternalTask topic1Task = "topic1".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        LockedExternalTask topic2Task = "topic2".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        ExternalTaskServiceTest.assertEquals((String)"topic1", (String)topic1Task.getTopicName());
        ExternalTaskServiceTest.assertEquals((String)"topic2", (String)topic2Task.getTopicName());
        VariableMap topic1Variables = topic1Task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)2, (int)topic1Variables.size());
        ExternalTaskServiceTest.assertEquals((Object)1L, (Object)topic1Variables.get((Object)"var1"));
        ExternalTaskServiceTest.assertEquals((Object)1L, (Object)topic1Variables.get((Object)"var2"));
        VariableMap topic2Variables = topic2Task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)1, (int)topic2Variables.size());
        ExternalTaskServiceTest.assertEquals((Object)2L, (Object)topic2Variables.get((Object)"var1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml"})
    public void testFetchMultipleTopicsMaxTasks() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        }
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 10000L).topic("topic3", 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testComplete() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterExternalTask").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testCompleteWithVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, (Map)Variables.createVariables().putValue("var", (Object)42));
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterExternalTask").done());
        ExternalTaskServiceTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testCompleteWithWrongWorkerId() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), "someCrazyWorkerId");
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            this.assertTextPresent("cannot be completed by worker 'someCrazyWorkerId'. It is locked by worker 'aWorkerId'.", e.getMessage());
        }
    }

    public void testCompleteNonExistingTask() {
        try {
            this.externalTaskService.complete("nonExistingTaskId", WORKER_ID);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    public void testCompleteNullTaskId() {
        try {
            this.externalTaskService.complete(null, WORKER_ID);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("externalTaskId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        try {
            this.externalTaskService.complete(task.getId(), null);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.complete(task.getId(), WORKER_ID);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
        this.assertProcessNotEnded(processInstance.getId());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testLocking() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteLockExpiredTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteReclaimedLockExpiredTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        List reclaimedTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId").topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("cannot be completed by worker 'aWorkerId'. It is locked by worker 'anotherWorkerId'.", e.getMessage());
        }
        this.externalTaskService.complete(((LockedExternalTask)reclaimedTasks.get(0)).getId(), "anotherWorkerId");
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        ExternalTaskServiceTest.assertEquals((int)0, (int)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testExternalTaskExecutionTreeExpansion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("boundaryExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask externalTask = (LockedExternalTask)tasks.get(0);
        this.runtimeService.correlateMessage("Message");
        this.externalTaskService.complete(externalTask.getId(), WORKER_ID);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterBoundaryTask").done());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(afterBoundaryTask.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testExternalTaskExecutionTreeCompaction() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask externalTask = (LockedExternalTask)tasks.get(0);
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(userTask.getId());
        this.externalTaskService.complete(externalTask.getId(), WORKER_ID);
        tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUnlock() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.unlock(task.getId());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask reAcquiredTask = (LockedExternalTask)externalTasks.get(0);
        ExternalTaskServiceTest.assertEquals((String)task.getId(), (String)reAcquiredTask.getId());
    }

    public void testUnlockNullTaskId() {
        try {
            this.externalTaskService.unlock(null);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("externalTaskId is null", e.getMessage());
        }
    }

    public void testUnlockNonExistingTask() {
        try {
            this.externalTaskService.unlock("nonExistingId");
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("Cannot find external task with id nonExistingId", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailure() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        String errorMessage = "errorMessage";
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, 5, 3000L);
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)tasks.size());
        task = (LockedExternalTask)tasks.get(0);
        ExternalTaskServiceTest.assertEquals((String)errorMessage, (String)task.getErrorMessage());
        ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureZeroRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        String errorMessage = "errorMessage";
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, 0, 3000L);
        ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)incident);
        ExternalTaskServiceTest.assertNotNull((Object)incident.getId());
        ExternalTaskServiceTest.assertEquals((String)errorMessage, (String)incident.getIncidentMessage());
        ExternalTaskServiceTest.assertEquals((String)task.getExecutionId(), (String)incident.getExecutionId());
        ExternalTaskServiceTest.assertEquals((String)"externalTask", (String)incident.getActivityId());
        ExternalTaskServiceTest.assertEquals((String)incident.getId(), (String)incident.getCauseIncidentId());
        ExternalTaskServiceTest.assertEquals((String)"failedExternalTask", (String)incident.getIncidentType());
        ExternalTaskServiceTest.assertEquals((String)task.getProcessDefinitionId(), (String)incident.getProcessDefinitionId());
        ExternalTaskServiceTest.assertEquals((String)task.getProcessInstanceId(), (String)incident.getProcessInstanceId());
        ExternalTaskServiceTest.assertEquals((String)incident.getId(), (String)incident.getRootCauseIncidentId());
        AssertUtil.assertEqualsSecondPrecision(this.nowMinus(4000L), incident.getIncidentTimestamp());
        ExternalTaskServiceTest.assertEquals((String)task.getId(), (String)incident.getConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureAndDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, "someError", 0, 10000L);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureThenComplete() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, "someError", 0, 10000L);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        Task followingTask = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)followingTask);
        ExternalTaskServiceTest.assertEquals((String)"afterExternalTask", (String)followingTask.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureWithWrongWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), "someCrazyWorkerId", "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            this.assertTextPresent("Failure of External Task " + ((LockedExternalTask)externalTasks.get(0)).getId() + " cannot be reported by worker 'someCrazyWorkerId'. It is locked by worker '" + WORKER_ID + "'.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNonExistingTask() {
        try {
            this.externalTaskService.handleFailure("nonExistingTaskId", WORKER_ID, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNullTaskId() {
        try {
            this.externalTaskService.handleFailure(null, WORKER_ID, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("externalTaskId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), null, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNegativeLockDuration() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", 5, -10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("retryDuration is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNegativeRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", -5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("retries is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNullErrorMessage() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, null, 5, 10000L);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        ExternalTaskServiceTest.assertNull((Object)task.getErrorMessage());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
        this.assertProcessNotEnded(processInstance.getId());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", 5, 10000L);
        ExternalTask updatedTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskServiceTest.assertEquals((int)5, (int)updatedTask.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.setRetries(((LockedExternalTask)externalTasks.get(0)).getId(), 5);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesResolvesFailureIncident() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask lockedTask = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.handleFailure(lockedTask.getId(), WORKER_ID, "error", 0, 10000L);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.externalTaskService.setRetries(lockedTask.getId(), 5);
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            ExternalTaskServiceTest.assertNotNull((Object)historicIncident);
            ExternalTaskServiceTest.assertEquals((String)incident.getId(), (String)historicIncident.getId());
            ExternalTaskServiceTest.assertTrue((boolean)historicIncident.isResolved());
        }
        ClockUtil.setCurrentTime((Date)this.nowPlus(13000L));
        externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((String)lockedTask.getId(), (String)((LockedExternalTask)externalTasks.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesToZero() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask lockedTask = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.setRetries(lockedTask.getId(), 0);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)incident);
        ExternalTaskServiceTest.assertEquals((String)lockedTask.getId(), (String)incident.getConfiguration());
        this.externalTaskService.setRetries(lockedTask.getId(), 5);
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesNegative() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.setRetries(((LockedExternalTask)externalTasks.get(0)).getId(), -5);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("retries is not greater than or equal to 0", e.getMessage());
        }
    }

    public void testSetRetriesNonExistingTask() {
        try {
            this.externalTaskService.setRetries("someExternalTaskId", 5);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("externalTask is null", e.getMessage());
        }
    }

    public void testSetRetriesNullTaskId() {
        try {
            this.externalTaskService.setRetries(null, 5);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("externalTaskId is null", e.getMessage());
        }
    }

    @Deployment
    public void testCancelExternalTaskWithBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("boundaryExternalTaskProcess");
        ExternalTaskServiceTest.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().count());
        this.runtimeService.correlateMessage("Message");
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)afterBoundaryTask);
        ExternalTaskServiceTest.assertEquals((String)"afterBoundaryTask", (String)afterBoundaryTask.getTaskDefinitionKey());
    }

    protected Date nowPlus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() + millis);
    }

    protected Date nowMinus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() - millis);
    }
}

