/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Picture;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.identity.Account;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class IdentityServiceTest
extends PluggableProcessEngineTestCase {
    public void testIsReadOnly() {
        IdentityServiceTest.assertFalse((boolean)this.identityService.isReadOnly());
    }

    public void testUserInfo() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue");
        IdentityServiceTest.assertEquals((String)"myvalue", (String)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue2");
        IdentityServiceTest.assertEquals((String)"myvalue2", (String)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.deleteUserInfo("testuser", "myinfo");
        IdentityServiceTest.assertNull((Object)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.deleteUser(user.getId());
    }

    public void testUserAccount() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername", "mygooglepwd", null);
        Account googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        IdentityServiceTest.assertEquals((String)"google", (String)googleAccount.getName());
        IdentityServiceTest.assertEquals((String)"mygoogleusername", (String)googleAccount.getUsername());
        IdentityServiceTest.assertEquals((String)"mygooglepwd", (String)googleAccount.getPassword());
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername2", "mygooglepwd2", null);
        googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        IdentityServiceTest.assertEquals((String)"google", (String)googleAccount.getName());
        IdentityServiceTest.assertEquals((String)"mygoogleusername2", (String)googleAccount.getUsername());
        IdentityServiceTest.assertEquals((String)"mygooglepwd2", (String)googleAccount.getPassword());
        this.identityService.setUserAccount("testuser", "123", "alfresco", "myalfrescousername", "myalfrescopwd", null);
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue");
        this.identityService.setUserInfo("testuser", "myinfo2", "myvalue2");
        ArrayList<String> expectedUserAccountNames = new ArrayList<String>();
        expectedUserAccountNames.add("google");
        expectedUserAccountNames.add("alfresco");
        List userAccountNames = this.identityService.getUserAccountNames("testuser");
        this.assertListElementsMatch(expectedUserAccountNames, userAccountNames);
        this.identityService.deleteUserAccount("testuser", "google");
        expectedUserAccountNames.remove("google");
        userAccountNames = this.identityService.getUserAccountNames("testuser");
        this.assertListElementsMatch(expectedUserAccountNames, userAccountNames);
        this.identityService.deleteUser(user.getId());
    }

    private void assertListElementsMatch(List<String> list1, List<String> list2) {
        if (list1 != null) {
            IdentityServiceTest.assertNotNull(list2);
            IdentityServiceTest.assertEquals((int)list1.size(), (int)list2.size());
            for (String value : list1) {
                IdentityServiceTest.assertTrue((boolean)list2.contains(value));
            }
        } else {
            IdentityServiceTest.assertNull(list2);
        }
    }

    public void testUserAccountDetails() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        HashMap<String, String> accountDetails = new HashMap<String, String>();
        accountDetails.put("server", "localhost");
        accountDetails.put("port", "35");
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername", "mygooglepwd", accountDetails);
        Account googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        IdentityServiceTest.assertEquals(accountDetails, (Object)googleAccount.getDetails());
        this.identityService.deleteUser(user.getId());
    }

    public void testCreateExistingUser() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        try {
            User secondUser = this.identityService.newUser("testuser");
            this.identityService.saveUser(secondUser);
            IdentityServiceTest.fail((String)"Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testUpdateUser() {
        User user = this.identityService.newUser("johndoe");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setEmail("johndoe@alfresco.com");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        user.setEmail("updated@alfresco.com");
        user.setFirstName("Jane");
        user.setLastName("Donnel");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        IdentityServiceTest.assertEquals((String)"Jane", (String)user.getFirstName());
        IdentityServiceTest.assertEquals((String)"Donnel", (String)user.getLastName());
        IdentityServiceTest.assertEquals((String)"updated@alfresco.com", (String)user.getEmail());
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword("johndoe", "s3cret"));
        this.identityService.deleteUser(user.getId());
    }

    public void testUserPicture() {
        User user = this.identityService.newUser("johndoe");
        this.identityService.saveUser(user);
        String userId = user.getId();
        Picture picture = new Picture("niceface".getBytes(), "image/string");
        this.identityService.setUserPicture(userId, picture);
        picture = this.identityService.getUserPicture(userId);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        IdentityServiceTest.assertTrue((String)"byte arrays differ", (boolean)Arrays.equals("niceface".getBytes(), picture.getBytes()));
        IdentityServiceTest.assertEquals((String)"image/string", (String)picture.getMimeType());
        this.identityService.deleteUserPicture("johndoe");
        this.identityService.deleteUserPicture("someone-else-we-dont-know");
        picture = this.identityService.getUserPicture("johndoe");
        IdentityServiceTest.assertNull((Object)picture);
        picture = new Picture("niceface".getBytes(), "image/string");
        this.identityService.setUserPicture(userId, picture);
        this.identityService.deleteUser(user.getId());
    }

    public void testUpdateGroup() {
        Group group = this.identityService.newGroup("sales");
        group.setName("Sales");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        group.setName("Updated");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        IdentityServiceTest.assertEquals((String)"Updated", (String)group.getName());
        this.identityService.deleteGroup(group.getId());
    }

    public void findUserByUnexistingId() {
        User user = (User)this.identityService.createUserQuery().userId("unexistinguser").singleResult();
        IdentityServiceTest.assertNull((Object)user);
    }

    public void findGroupByUnexistingId() {
        Group group = (Group)this.identityService.createGroupQuery().groupId("unexistinggroup").singleResult();
        IdentityServiceTest.assertNull((Object)group);
    }

    public void testCreateMembershipUnexistingGroup() {
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        try {
            this.identityService.createMembership(johndoe.getId(), "unexistinggroup");
            IdentityServiceTest.fail((String)"Expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteUser(johndoe.getId());
    }

    public void testCreateMembershipUnexistingUser() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        try {
            this.identityService.createMembership("unexistinguser", sales.getId());
            IdentityServiceTest.fail((String)"Expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteGroup(sales.getId());
    }

    public void testCreateMembershipAlreadyExisting() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.createMembership(johndoe.getId(), sales.getId());
        try {
            this.identityService.createMembership(johndoe.getId(), sales.getId());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteGroup(sales.getId());
        this.identityService.deleteUser(johndoe.getId());
    }

    public void testSaveGroupNullArgument() {
        try {
            this.identityService.saveGroup(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("group is null", ae.getMessage());
        }
    }

    public void testSaveUserNullArgument() {
        try {
            this.identityService.saveUser(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("user is null", ae.getMessage());
        }
    }

    public void testFindGroupByIdNullArgument() {
        try {
            this.identityService.createGroupQuery().groupId(null).singleResult();
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("id is null", ae.getMessage());
        }
    }

    public void testCreateMembershipNullArguments() {
        try {
            this.identityService.createMembership(null, "group");
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
        try {
            this.identityService.createMembership("userId", null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("groupId is null", ae.getMessage());
        }
    }

    public void testFindGroupsByUserIdNullArguments() {
        try {
            this.identityService.createGroupQuery().groupMember(null).singleResult();
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
    }

    public void testFindUsersByGroupUnexistingGroup() {
        List users = this.identityService.createUserQuery().memberOfGroup("unexistinggroup").list();
        IdentityServiceTest.assertNotNull((Object)users);
        IdentityServiceTest.assertTrue((boolean)users.isEmpty());
    }

    public void testDeleteGroupNullArguments() {
        try {
            this.identityService.deleteGroup(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("groupId is null", ae.getMessage());
        }
    }

    public void testDeleteMembership() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.createMembership(johndoe.getId(), sales.getId());
        List groups = this.identityService.createGroupQuery().groupMember(johndoe.getId()).list();
        IdentityServiceTest.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        IdentityServiceTest.assertEquals((String)"sales", (String)((Group)groups.get(0)).getId());
        this.identityService.deleteMembership(johndoe.getId(), sales.getId());
        groups = this.identityService.createGroupQuery().groupMember(johndoe.getId()).list();
        IdentityServiceTest.assertTrue((groups.size() == 0 ? 1 : 0) != 0);
        this.identityService.deleteGroup("sales");
        this.identityService.deleteUser("johndoe");
    }

    public void testDeleteMembershipWhenUserIsNoMember() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.deleteMembership(johndoe.getId(), sales.getId());
        this.identityService.deleteGroup("sales");
        this.identityService.deleteUser("johndoe");
    }

    public void testDeleteMembershipUnexistingGroup() {
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.deleteMembership(johndoe.getId(), "unexistinggroup");
        this.identityService.deleteUser(johndoe.getId());
    }

    public void testDeleteMembershipUnexistingUser() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        this.identityService.deleteMembership("unexistinguser", sales.getId());
        this.identityService.deleteGroup(sales.getId());
    }

    public void testDeleteMemberschipNullArguments() {
        try {
            this.identityService.deleteMembership(null, "group");
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
        try {
            this.identityService.deleteMembership("user", null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("groupId is null", ae.getMessage());
        }
    }

    public void testDeleteUserNullArguments() {
        try {
            this.identityService.deleteUser(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
    }

    public void testDeleteUserUnexistingUserId() {
        this.identityService.deleteUser("unexistinguser");
    }

    public void testCheckPassword() {
        User user = this.identityService.newUser("secureUser");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "s3cret"));
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword(user.getId(), "wrong"));
        this.identityService.deleteUser(user.getId());
    }

    public void testUpdatePassword() {
        User user = this.identityService.newUser("secureUser");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "s3cret"));
        user.setPassword("new-password");
        this.identityService.saveUser(user);
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "new-password"));
        this.identityService.deleteUser(user.getId());
    }

    public void testCheckPasswordNullSafe() {
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword("userId", null));
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword(null, "passwd"));
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword(null, null));
    }

    public void testUserOptimisticLockingException() {
        User user = this.identityService.newUser("kermit");
        this.identityService.saveUser(user);
        User user1 = (User)this.identityService.createUserQuery().singleResult();
        User user2 = (User)this.identityService.createUserQuery().singleResult();
        user1.setFirstName("name one");
        this.identityService.saveUser(user1);
        try {
            user2.setFirstName("name two");
            this.identityService.saveUser(user2);
            IdentityServiceTest.fail((String)"Expected an exception");
        }
        catch (OptimisticLockingException e) {
            // empty catch block
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testGroupOptimisticLockingException() {
        Group group = this.identityService.newGroup("group");
        this.identityService.saveGroup(group);
        Group group1 = (Group)this.identityService.createGroupQuery().singleResult();
        Group group2 = (Group)this.identityService.createGroupQuery().singleResult();
        group1.setName("name one");
        this.identityService.saveGroup(group1);
        try {
            group2.setName("name two");
            this.identityService.saveGroup(group2);
            IdentityServiceTest.fail((String)"Expected an exception");
        }
        catch (OptimisticLockingException e) {
            // empty catch block
        }
        this.identityService.deleteGroup(group.getId());
    }

    public void testSaveUserWithGenericResourceId() {
        User user = this.identityService.newUser("*");
        try {
            this.identityService.saveUser(user);
            IdentityServiceTest.fail((String)"it should not be possible to save a user with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("has an invalid id: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
    }

    public void testSaveGroupWithGenericResourceId() {
        Group group = this.identityService.newGroup("*");
        try {
            this.identityService.saveGroup(group);
            IdentityServiceTest.fail((String)"it should not be possible to save a group with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("has an invalid id: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
    }

    public void testSetAuthenticatedIdToGenericId() {
        try {
            this.identityService.setAuthenticatedUserId("*");
            IdentityServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid user id provided: id cannot be *. * is a reserved identifier.", e.getMessage());
            IdentityServiceTest.assertNull((Object)this.identityService.getCurrentAuthentication());
        }
    }

    public void testSetAuthenticationUserIdToGenericId() {
        try {
            this.identityService.setAuthentication("*", Collections.emptyList());
            IdentityServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid user id provided: id cannot be *. * is a reserved identifier.", e.getMessage());
            IdentityServiceTest.assertNull((Object)this.identityService.getCurrentAuthentication());
        }
        try {
            this.identityService.setAuthentication("aUserId", Arrays.asList("*"));
            IdentityServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("At least one invalid group id provided: id cannot be *. * is a reserved identifier.", e.getMessage());
            IdentityServiceTest.assertNull((Object)this.identityService.getCurrentAuthentication());
        }
        try {
            this.identityService.setAuthentication(new Authentication("*", Collections.emptyList()));
            IdentityServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid user id provided: id cannot be *. * is a reserved identifier.", e.getMessage());
            IdentityServiceTest.assertNull((Object)this.identityService.getCurrentAuthentication());
        }
        try {
            this.identityService.setAuthentication(new Authentication("aUserId", Arrays.asList("*")));
            IdentityServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("At least one invalid group id provided: id cannot be *. * is a reserved identifier.", e.getMessage());
            IdentityServiceTest.assertNull((Object)this.identityService.getCurrentAuthentication());
        }
    }

    public void testAuthentication() {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword("johndoe", "xxx"));
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
        this.identityService.deleteUser("johndoe");
    }

    public void testFindGroupsByUserAndType() {
        Group sales = this.identityService.newGroup("sales");
        sales.setType("hierarchy");
        this.identityService.saveGroup(sales);
        Group development = this.identityService.newGroup("development");
        development.setType("hierarchy");
        this.identityService.saveGroup(development);
        Group admin = this.identityService.newGroup("admin");
        admin.setType("security-role");
        this.identityService.saveGroup(admin);
        Group user = this.identityService.newGroup("user");
        user.setType("security-role");
        this.identityService.saveGroup(user);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        User joesmoe = this.identityService.newUser("joesmoe");
        this.identityService.saveUser(joesmoe);
        User jackblack = this.identityService.newUser("jackblack");
        this.identityService.saveUser(jackblack);
        this.identityService.createMembership("johndoe", "sales");
        this.identityService.createMembership("johndoe", "user");
        this.identityService.createMembership("johndoe", "admin");
        this.identityService.createMembership("joesmoe", "user");
        List groups = this.identityService.createGroupQuery().groupMember("johndoe").groupType("security-role").list();
        Set<String> groupIds = this.getGroupIds(groups);
        HashSet<String> expectedGroupIds = new HashSet<String>();
        expectedGroupIds.add("user");
        expectedGroupIds.add("admin");
        IdentityServiceTest.assertEquals(expectedGroupIds, groupIds);
        groups = this.identityService.createGroupQuery().groupMember("joesmoe").groupType("security-role").list();
        groupIds = this.getGroupIds(groups);
        expectedGroupIds = new HashSet();
        expectedGroupIds.add("user");
        IdentityServiceTest.assertEquals(expectedGroupIds, groupIds);
        groups = this.identityService.createGroupQuery().groupMember("jackblack").groupType("security-role").list();
        IdentityServiceTest.assertTrue((boolean)groups.isEmpty());
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("development");
        this.identityService.deleteGroup("admin");
        this.identityService.deleteGroup("user");
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("jackblack");
    }

    public void testUser() {
        User user = this.identityService.newUser("johndoe");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setEmail("johndoe@alfresco.com");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        IdentityServiceTest.assertEquals((String)"johndoe", (String)user.getId());
        IdentityServiceTest.assertEquals((String)"John", (String)user.getFirstName());
        IdentityServiceTest.assertEquals((String)"Doe", (String)user.getLastName());
        IdentityServiceTest.assertEquals((String)"johndoe@alfresco.com", (String)user.getEmail());
        this.identityService.deleteUser("johndoe");
    }

    public void testGroup() {
        Group group = this.identityService.newGroup("sales");
        group.setName("Sales division");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        IdentityServiceTest.assertEquals((String)"sales", (String)group.getId());
        IdentityServiceTest.assertEquals((String)"Sales division", (String)group.getName());
        this.identityService.deleteGroup("sales");
    }

    public void testMembership() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        Group development = this.identityService.newGroup("development");
        this.identityService.saveGroup(development);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        User joesmoe = this.identityService.newUser("joesmoe");
        this.identityService.saveUser(joesmoe);
        User jackblack = this.identityService.newUser("jackblack");
        this.identityService.saveUser(jackblack);
        this.identityService.createMembership("johndoe", "sales");
        this.identityService.createMembership("joesmoe", "sales");
        this.identityService.createMembership("joesmoe", "development");
        this.identityService.createMembership("jackblack", "development");
        List groups = this.identityService.createGroupQuery().groupMember("johndoe").list();
        IdentityServiceTest.assertEquals((Object)this.createStringSet("sales"), this.getGroupIds(groups));
        groups = this.identityService.createGroupQuery().groupMember("joesmoe").list();
        IdentityServiceTest.assertEquals((Object)this.createStringSet("sales", "development"), this.getGroupIds(groups));
        groups = this.identityService.createGroupQuery().groupMember("jackblack").list();
        IdentityServiceTest.assertEquals((Object)this.createStringSet("development"), this.getGroupIds(groups));
        List users = this.identityService.createUserQuery().memberOfGroup("sales").list();
        IdentityServiceTest.assertEquals((Object)this.createStringSet("johndoe", "joesmoe"), this.getUserIds(users));
        users = this.identityService.createUserQuery().memberOfGroup("development").list();
        IdentityServiceTest.assertEquals((Object)this.createStringSet("joesmoe", "jackblack"), this.getUserIds(users));
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("development");
        this.identityService.deleteUser("jackblack");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("johndoe");
    }

    private Object createStringSet(String ... strings) {
        HashSet<String> stringSet = new HashSet<String>();
        for (String string : strings) {
            stringSet.add(string);
        }
        return stringSet;
    }

    public Set<String> getGroupIds(List<Group> groups) {
        HashSet<String> groupIds = new HashSet<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    public Set<String> getUserIds(List<User> users) {
        HashSet<String> userIds = new HashSet<String>();
        for (User user : users) {
            userIds.add(user.getId());
        }
        return userIds;
    }
}

