/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;

public class ManagementServiceTest
extends PluggableProcessEngineTestCase {
    public void testGetMetaDataForUnexistingTable() {
        TableMetaData metaData = this.managementService.getTableMetaData("unexistingtable");
        ManagementServiceTest.assertNull((Object)metaData);
    }

    public void testGetMetaDataNullTableName() {
        try {
            this.managementService.getTableMetaData(null);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("tableName is null", re.getMessage());
        }
    }

    public void testExecuteJobNullJobId() {
        try {
            this.managementService.executeJob(null);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("jobId is null", re.getMessage());
        }
    }

    public void testExecuteJobUnexistingJob() {
        try {
            this.managementService.executeJob("unexistingjob");
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No job found with id", ae.getMessage());
        }
    }

    @Deployment
    public void testGetJobExceptionStacktrace() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        try {
            this.managementService.executeJob(timerJob.getId());
            ManagementServiceTest.fail((String)"RuntimeException from within the script task expected");
        }
        catch (RuntimeException re) {
            this.assertTextPresent("This is an exception thrown from scriptTask", re.getMessage());
        }
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)timerJob);
        Assert.assertNotNull((Object)timerJob.getExceptionMessage());
        this.assertTextPresent("This is an exception thrown from scriptTask", timerJob.getExceptionMessage());
        String exceptionStack = this.managementService.getJobExceptionStacktrace(timerJob.getId());
        Assert.assertNotNull((Object)exceptionStack);
        this.assertTextPresent("This is an exception thrown from scriptTask", exceptionStack);
    }

    public void testgetJobExceptionStacktraceUnexistingJobId() {
        try {
            this.managementService.getJobExceptionStacktrace("unexistingjob");
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("No job found with id unexistingjob", re.getMessage());
        }
    }

    public void testgetJobExceptionStacktraceNullJobId() {
        try {
            this.managementService.getJobExceptionStacktrace(null);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("jobId is null", re.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testSetJobRetries() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        ManagementServiceTest.assertEquals((int)3, (int)timerJob.getRetries());
        this.managementService.setJobRetries(timerJob.getId(), 5);
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertEquals((int)5, (int)timerJob.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testSetJobRetriesNullCreatesIncident() {
        ManagementServiceTest.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        ManagementServiceTest.assertEquals((int)3, (int)timerJob.getRetries());
        this.managementService.setJobRetries(timerJob.getId(), 0);
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertEquals((int)0, (int)timerJob.getRetries());
        ManagementServiceTest.assertEquals((long)1L, (long)this.runtimeService.createIncidentQuery().count());
    }

    public void testSetJobRetriesUnexistingJobId() {
        try {
            this.managementService.setJobRetries("unexistingjob", 5);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("No job found with id 'unexistingjob'.", re.getMessage());
        }
    }

    public void testSetJobRetriesEmptyJobId() {
        try {
            this.managementService.setJobRetries("", 5);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Either job definition id or job id has to be provided as parameter.", re.getMessage());
        }
    }

    public void testSetJobRetriesJobIdNull() {
        try {
            this.managementService.setJobRetries(null, 5);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Either job definition id or job id has to be provided as parameter.", re.getMessage());
        }
    }

    public void testSetJobRetriesNegativeNumberOfRetries() {
        try {
            this.managementService.setJobRetries("unexistingjob", -1);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("The number of job retries must be a non-negative Integer, but '-1' has been provided.", re.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testSetJobRetriesByJobDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        this.executeAvailableJobs();
        JobQuery query = this.managementService.createJobQuery().processInstanceId(processInstance.getId());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Job timerJob = (Job)query.singleResult();
        ManagementServiceTest.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        ManagementServiceTest.assertEquals((int)0, (int)timerJob.getRetries());
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 5);
        timerJob = (Job)query.singleResult();
        ManagementServiceTest.assertEquals((int)5, (int)timerJob.getRetries());
    }

    public void testSetJobRetriesByJobDefinitionIdEmptyJobDefinitionId() {
        try {
            this.managementService.setJobRetriesByJobDefinitionId("", 5);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Either job definition id or job id has to be provided as parameter.", re.getMessage());
        }
    }

    public void testSetJobRetriesByJobDefinitionIdNull() {
        try {
            this.managementService.setJobRetriesByJobDefinitionId(null, 5);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Either job definition id or job id has to be provided as parameter.", re.getMessage());
        }
    }

    public void testSetJobRetriesByJobDefinitionIdNegativeNumberOfRetries() {
        try {
            this.managementService.setJobRetries("unexistingjob", -1);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("The number of job retries must be a non-negative Integer, but '-1' has been provided.", re.getMessage());
        }
    }

    public void testSetJobRetriesUnlocksInconsistentJob() {
        this.createJob(0, "owner", ClockUtil.getCurrentTime());
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 3);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        ManagementServiceTest.assertNotNull((Object)job);
        ManagementServiceTest.assertNull((Object)job.getLockOwner());
        ManagementServiceTest.assertNull((Object)job.getLockExpirationTime());
        ManagementServiceTest.assertEquals((int)3, (int)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
        this.createJob(2, "owner", null);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 3);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        ManagementServiceTest.assertNotNull((Object)job);
        ManagementServiceTest.assertNull((Object)job.getLockOwner());
        ManagementServiceTest.assertNull((Object)job.getLockExpirationTime());
        ManagementServiceTest.assertEquals((int)3, (int)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
        this.createJob(2, "owner", ClockUtil.getCurrentTime());
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 3);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        ManagementServiceTest.assertNotNull((Object)job);
        ManagementServiceTest.assertNotNull((Object)job.getLockOwner());
        ManagementServiceTest.assertNotNull((Object)job.getLockExpirationTime());
        ManagementServiceTest.assertEquals((int)3, (int)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
    }

    protected void createJob(final int retries, final String owner, final Date lockExpirationTime) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                MessageEntity job = new MessageEntity();
                job.setJobHandlerType("any");
                job.setLockOwner(owner);
                job.setLockExpirationTime(lockExpirationTime);
                job.setRetries(retries);
                jobManager.send(job);
                return null;
            }
        });
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testSetJobRetriesByDefinitionUnlocksInconsistentJobs() {
        final JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                MessageEntity job = new MessageEntity();
                job.setJobDefinitionId(jobDefinition.getId());
                job.setJobHandlerType("any");
                job.setLockOwner("owner");
                job.setLockExpirationTime(ClockUtil.getCurrentTime());
                job.setRetries(0);
                jobManager.send(job);
                return null;
            }
        });
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 3);
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        ManagementServiceTest.assertNotNull((Object)job);
        ManagementServiceTest.assertNull((Object)job.getLockOwner());
        ManagementServiceTest.assertNull((Object)job.getLockExpirationTime());
        ManagementServiceTest.assertEquals((int)3, (int)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
    }

    protected void deleteJobAndIncidents(final Job job) {
        final List incidents = this.historyService.createHistoricIncidentQuery().incidentType("failedJob").list();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ((JobEntity)job).delete();
                HistoricIncidentManager historicIncidentManager = commandContext.getHistoricIncidentManager();
                for (HistoricIncident incident : incidents) {
                    HistoricIncidentEntity incidentEntity = (HistoricIncidentEntity)incident;
                    historicIncidentManager.delete((DbEntity)incidentEntity);
                }
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                return null;
            }
        });
    }

    public void testDeleteJobNullJobId() {
        try {
            this.managementService.deleteJob(null);
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("jobId is null", re.getMessage());
        }
    }

    public void testDeleteJobUnexistingJob() {
        try {
            this.managementService.deleteJob("unexistingjob");
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No job found with id", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/timerOnTask.bpmn20.xml"})
    public void testDeleteJobDeletion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timerOnTask");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNotNull((String)"Task timer should be there", (Object)timerJob);
        this.managementService.deleteJob(timerJob.getId());
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNull((String)"There should be no job now. It was deleted", (Object)timerJob);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/timerOnTask.bpmn20.xml"})
    public void testDeleteJobThatWasAlreadyAcquired() {
        ClockUtil.setCurrentTime((Date)new Date());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timerOnTask");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 0x6DDD00L));
        ProcessEngineImpl processEngineImpl = (ProcessEngineImpl)this.processEngine;
        JobExecutor jobExecutor = processEngineImpl.getProcessEngineConfiguration().getJobExecutor();
        AcquireJobsCmd acquireJobsCmd = new AcquireJobsCmd(jobExecutor);
        CommandExecutor commandExecutor = processEngineImpl.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)acquireJobsCmd);
        try {
            this.managementService.deleteJob(timerJob.getId());
            ManagementServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        this.managementService.executeJob(timerJob.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testSetJobDuedate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        ManagementServiceTest.assertNotNull((Object)timerJob.getDuedate());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 3);
        this.managementService.setJobDuedate(timerJob.getId(), cal.getTime());
        Job newTimerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        int SECOND = 1000;
        ManagementServiceTest.assertEquals((long)(cal.getTime().getTime() / (long)SECOND * (long)SECOND), (long)(newTimerJob.getDuedate().getTime() / (long)SECOND * (long)SECOND));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testSetJobDuedateDateNull() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        ManagementServiceTest.assertNotNull((Object)timerJob.getDuedate());
        this.managementService.setJobDuedate(timerJob.getId(), null);
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ManagementServiceTest.assertNull((Object)timerJob.getDuedate());
    }

    public void testSetJobDuedateJobIdNull() {
        try {
            this.managementService.setJobDuedate(null, new Date());
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("The job id is mandatory, but 'null' has been provided.", re.getMessage());
        }
    }

    public void testSetJobDuedateEmptyJobId() {
        try {
            this.managementService.setJobDuedate("", new Date());
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("The job id is mandatory, but '' has been provided.", re.getMessage());
        }
    }

    public void testSetJobDuedateUnexistingJobId() {
        try {
            this.managementService.setJobDuedate("unexistingjob", new Date());
            ManagementServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("No job found with id 'unexistingjob'.", re.getMessage());
        }
    }

    public void testGetProperties() {
        Map properties = this.managementService.getProperties();
        ManagementServiceTest.assertNotNull((Object)properties);
        ManagementServiceTest.assertFalse((boolean)properties.isEmpty());
    }

    public void testSetProperty() {
        String name = "testProp";
        String value = "testValue";
        this.managementService.setProperty("testProp", "testValue");
        Map properties = this.managementService.getProperties();
        ManagementServiceTest.assertTrue((boolean)properties.containsKey("testProp"));
        String storedValue = (String)properties.get("testProp");
        ManagementServiceTest.assertEquals((String)"testValue", (String)storedValue);
        this.managementService.deleteProperty("testProp");
    }

    public void testDeleteProperty() {
        String name = "testProp";
        String value = "testValue";
        this.managementService.setProperty("testProp", "testValue");
        Map properties = this.managementService.getProperties();
        ManagementServiceTest.assertTrue((boolean)properties.containsKey("testProp"));
        String storedValue = (String)properties.get("testProp");
        ManagementServiceTest.assertEquals((String)"testValue", (String)storedValue);
        this.managementService.deleteProperty("testProp");
        properties = this.managementService.getProperties();
        ManagementServiceTest.assertFalse((boolean)properties.containsKey("testProp"));
    }

    public void testDeleteNonexistingProperty() {
        this.managementService.deleteProperty("non existing");
    }

    public void testGetHistoryLevel() {
        int historyLevel = this.managementService.getHistoryLevel();
        ManagementServiceTest.assertEquals((int)this.processEngineConfiguration.getHistoryLevel().getId(), (int)historyLevel);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobPriority() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobPriority(job.getId(), 42L);
        job = (Job)this.managementService.createJobQuery().singleResult();
        ManagementServiceTest.assertEquals((long)42L, (long)job.getPriority());
    }

    public void testSetJobPriorityForNonExistingJob() {
        try {
            this.managementService.setJobPriority("nonExistingJob", 42L);
            ManagementServiceTest.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.assertTextPresentIgnoreCase("No job found with id 'nonExistingJob'", e.getMessage());
        }
    }

    public void testSetJobPriorityForNullJob() {
        try {
            this.managementService.setJobPriority(null, 42L);
            ManagementServiceTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            this.assertTextPresentIgnoreCase("Job id must not be null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobPriorityToExtremeValues() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobPriority(job.getId(), Long.MAX_VALUE);
        job = (Job)this.managementService.createJobQuery().singleResult();
        ManagementServiceTest.assertEquals((long)Long.MAX_VALUE, (long)job.getPriority());
        this.managementService.setJobPriority(job.getId(), -9223372036854775807L);
        job = (Job)this.managementService.createJobQuery().singleResult();
        ManagementServiceTest.assertEquals((long)-9223372036854775807L, (long)job.getPriority());
    }

    public void testTableCount() {
        Map tableCount = this.managementService.getTableCount();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        ManagementServiceTest.assertEquals((Object)new Long(5L), tableCount.get(tablePrefix + "ACT_GE_PROPERTY"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_GE_BYTEARRAY"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RE_DEPLOYMENT"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RU_EXECUTION"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_ID_GROUP"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_ID_MEMBERSHIP"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_ID_USER"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RE_PROCDEF"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RU_TASK"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RU_IDENTITYLINK"));
    }

    public void testGetTableMetaData() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        TableMetaData tableMetaData = this.managementService.getTableMetaData(tablePrefix + "ACT_RU_TASK");
        ManagementServiceTest.assertEquals((int)tableMetaData.getColumnNames().size(), (int)tableMetaData.getColumnTypes().size());
        ManagementServiceTest.assertEquals((int)20, (int)tableMetaData.getColumnNames().size());
        int assigneeIndex = tableMetaData.getColumnNames().indexOf("ASSIGNEE_");
        int createTimeIndex = tableMetaData.getColumnNames().indexOf("CREATE_TIME_");
        ManagementServiceTest.assertTrue((assigneeIndex >= 0 ? 1 : 0) != 0);
        ManagementServiceTest.assertTrue((createTimeIndex >= 0 ? 1 : 0) != 0);
        this.assertOneOf(new String[]{"VARCHAR", "NVARCHAR2", "nvarchar", "NVARCHAR"}, (String)tableMetaData.getColumnTypes().get(assigneeIndex));
        this.assertOneOf(new String[]{"TIMESTAMP", "TIMESTAMP(6)", "datetime", "DATETIME", "DATETIME2"}, (String)tableMetaData.getColumnTypes().get(createTimeIndex));
    }

    private void assertOneOf(String[] possibleValues, String currentValue) {
        for (String value : possibleValues) {
            if (!currentValue.equals(value)) continue;
            return;
        }
        ManagementServiceTest.fail((String)("Value '" + currentValue + "' should be one of: " + Arrays.deepToString(possibleValues)));
    }

    public void testGetTablePage() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        List<String> taskIds = this.generateDummyTasks(20);
        TablePage tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").listPage(0, 5);
        ManagementServiceTest.assertEquals((long)0L, (long)tablePage.getFirstResult());
        ManagementServiceTest.assertEquals((long)5L, (long)tablePage.getSize());
        ManagementServiceTest.assertEquals((int)5, (int)tablePage.getRows().size());
        ManagementServiceTest.assertEquals((long)20L, (long)tablePage.getTotal());
        tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").listPage(14, 10);
        ManagementServiceTest.assertEquals((long)14L, (long)tablePage.getFirstResult());
        ManagementServiceTest.assertEquals((long)6L, (long)tablePage.getSize());
        ManagementServiceTest.assertEquals((int)6, (int)tablePage.getRows().size());
        ManagementServiceTest.assertEquals((long)20L, (long)tablePage.getTotal());
        this.taskService.deleteTasks(taskIds, true);
    }

    public void testGetSortedTablePage() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        List<String> taskIds = this.generateDummyTasks(15);
        TablePage tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").orderAsc("NAME_").listPage(1, 7);
        String[] expectedTaskNames = new String[]{"B", "C", "D", "E", "F", "G", "H"};
        this.verifyTaskNames(expectedTaskNames, tablePage.getRows());
        tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").orderDesc("NAME_").listPage(6, 8);
        expectedTaskNames = new String[]{"I", "H", "G", "F", "E", "D", "C", "B"};
        this.verifyTaskNames(expectedTaskNames, tablePage.getRows());
        this.taskService.deleteTasks(taskIds, true);
    }

    private void verifyTaskNames(String[] expectedTaskNames, List<Map<String, Object>> rowData) {
        ManagementServiceTest.assertEquals((int)expectedTaskNames.length, (int)rowData.size());
        String columnKey = "NAME_";
        for (int i = 0; i < expectedTaskNames.length; ++i) {
            Object o = rowData.get(i).get(columnKey);
            if (o == null) {
                o = rowData.get(i).get(columnKey.toLowerCase());
            }
            ManagementServiceTest.assertEquals((Object)expectedTaskNames[i], (Object)o);
        }
    }

    private List<String> generateDummyTasks(int nrOfTasks) {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (int i = 0; i < nrOfTasks; ++i) {
            Task task = this.taskService.newTask();
            task.setName((char)(65 + i) + "");
            this.taskService.saveTask(task);
            taskIds.add(task.getId());
        }
        return taskIds;
    }
}

