/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class AbstractMultiTenancyQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant 1";
    protected static final String TENANT_TWO = "tenant 2";
    protected String deploymentOneId;
    protected String deploymentTwoId;

    protected void setUp() throws Exception {
        this.deploymentOneId = this.deployProcessDefinitionForTenant(TENANT_ONE);
        this.deploymentTwoId = this.deployProcessDefinitionForTenant(TENANT_TWO);
        this.initScenario();
        super.setUp();
    }

    protected String deployProcessDefinitionForTenant(String tenantId) {
        return this.repositoryService.createDeployment().tenantId(tenantId).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy().getId();
    }

    protected abstract void initScenario();

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    protected void verifyQueryResults(Query<?, ?> query, int countExpected) {
        Assert.assertThat((Object)query.list().size(), (Matcher)CoreMatchers.is((Object)countExpected));
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)countExpected));
    }
}

