/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.api.multitenancy.AbstractMultiTenancyQueryTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDeploymentQueryTest
extends AbstractMultiTenancyQueryTest {
    @Override
    protected void initScenario() {
    }

    public void testQueryWithoutTenantId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQueryByTenantId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{"tenant 1"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
        query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{"tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryByTenantIds() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{"tenant 1", "tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQuerySortingAsc() {
        List deployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)deployments.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Deployment)deployments.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
        Assert.assertThat((Object)((Deployment)deployments.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
    }

    public void testQuerySortingDesc() {
        List deployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)deployments.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Deployment)deployments.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
        Assert.assertThat((Object)((Deployment)deployments.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
    }
}

