/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.test.api.multitenancy.AbstractMultiTenancyQueryTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyExecutionQueryTest
extends AbstractMultiTenancyQueryTest {
    @Override
    protected void initScenario() {
        this.startProcessInstanceForTenant("tenant 1");
        this.startProcessInstanceForTenant("tenant 2");
    }

    public void testQueryWithoutTenantId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQueryByTenantId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{"tenant 1"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
        query = this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{"tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryByTenantIds() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().tenantIdIn(new String[]{"tenant 1", "tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQuerySortingAsc() {
        List executions = ((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
    }

    public void testQuerySortingDesc() {
        List executions = ((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
    }

    protected void startProcessInstanceForTenant(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
    }
}

