/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.api.multitenancy.AbstractMultiTenancyQueryTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessDefinitionQueryTest
extends AbstractMultiTenancyQueryTest {
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";

    @Override
    protected void initScenario() {
    }

    public void testQueryWithoutTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQueryByTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{"tenant 1"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{"tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryByTenantIds() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{"tenant 1", "tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQueryByKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY);
        this.verifyQueryResults((Query<?, ?>)query, 2);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).tenantIdIn(new String[]{"tenant 1"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryByLatestWithoutTenantId() {
        String deploymentId = this.deployProcessDefinitionForTenant("tenant 1");
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().orderByTenantId().asc();
        this.verifyQueryResults((Query<?, ?>)query, 2);
        List processDefinitions = query.list();
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testQueryByLatestWithTenantId() {
        String deploymentId = this.deployProcessDefinitionForTenant("tenant 1");
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{"tenant 1"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
        ProcessDefinition processDefinition = (ProcessDefinition)query.singleResult();
        Assert.assertThat((Object)processDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
        Assert.assertThat((Object)processDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{"tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
        processDefinition = (ProcessDefinition)query.singleResult();
        Assert.assertThat((Object)processDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
        Assert.assertThat((Object)processDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testQueryByLatestWithTenantIds() {
        String deploymentId = this.deployProcessDefinitionForTenant("tenant 1");
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{"tenant 1", "tenant 2"}).orderByTenantId().asc();
        this.verifyQueryResults((Query<?, ?>)query, 2);
        List processDefinitions = query.list();
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testQuerySortingAsc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
    }

    public void testQuerySortingDesc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
    }
}

