/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.api.multitenancy.AbstractMultiTenancyQueryTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessInstanceQueryTest
extends AbstractMultiTenancyQueryTest {
    @Override
    protected void initScenario() {
        this.startProcessInstanceForTenant("tenant 1");
        this.startProcessInstanceForTenant("tenant 2");
    }

    public void testQueryWithoutTenantId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQueryByTenantId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{"tenant 1"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
        query = this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{"tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryByTenantIds() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{"tenant 1", "tenant 2"});
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQuerySortingAsc() {
        List processInstances = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)processInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
    }

    public void testQuerySortingDesc() {
        List processInstances = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)processInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 2"));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant 1"));
    }

    protected void startProcessInstanceForTenant(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
    }
}

