/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;

public class MultiTenancyRepositoryServiceTest
extends PluggableProcessEngineTestCase {
    protected void tearDown() throws Exception {
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testDeploymentWithoutTenantId() {
        this.createDeployment().deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        MultiTenancyRepositoryServiceTest.assertNotNull((Object)deployment);
        MultiTenancyRepositoryServiceTest.assertNull((Object)deployment.getTenantId());
    }

    public void testDeploymentWithTenantId() {
        this.createDeployment().tenantId("tenant 1").deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        MultiTenancyRepositoryServiceTest.assertNotNull((Object)deployment);
        MultiTenancyRepositoryServiceTest.assertEquals((String)"tenant 1", (String)deployment.getTenantId());
    }

    public void testPropagateTenantIdToProcessDefinition() {
        this.createDeployment().tenantId("tenant 1").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        MultiTenancyRepositoryServiceTest.assertNotNull((Object)processDefinition);
        MultiTenancyRepositoryServiceTest.assertEquals((String)"tenant 1", (String)processDefinition.getTenantId());
    }

    public void testProcessDefinitionVersionWithTenantId() {
        this.createDeployment().tenantId("tenant 1").deploy();
        this.createDeployment().tenantId("tenant 1").deploy();
        this.createDeployment().tenantId("tenant 2").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().asc()).orderByProcessDefinitionVersion().asc()).list();
        MultiTenancyRepositoryServiceTest.assertEquals((int)3, (int)processDefinitions.size());
        MultiTenancyRepositoryServiceTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        MultiTenancyRepositoryServiceTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        MultiTenancyRepositoryServiceTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(2)).getVersion());
    }

    protected DeploymentBuilder createDeployment() {
        return this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/repository/one.bpmn20.xml");
    }
}

