/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyRuntimeServiceTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ID = "tenant 1";
    protected String deploymentOneId;

    protected void setUp() throws Exception {
        this.deploymentOneId = this.repositoryService.createDeployment().tenantId(TENANT_ID).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/twoParallelTasksProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml").deploy().getId();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
    }

    public void testPropagateTenantIdToProcessInstance() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    public void testPropagateTenantIdToConcurrentExecution() {
        this.runtimeService.startProcessInstanceByKey("twoParallelTasksProcess");
        List executions = this.runtimeService.createExecutionQuery().list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
        Assert.assertThat((Object)((Execution)executions.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    public void testPropagateTenantIdToEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess");
        List executions = this.runtimeService.createExecutionQuery().list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }
}

