/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.variable.Variables;

public class ProcessInstantiationAtActivitiesTest
extends PluggableProcessEngineTestCase {
    protected static final String PARALLEL_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";
    protected static final String LISTENERS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.listeners.bpmn20.xml";
    protected static final String IO_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.ioMappings.bpmn20.xml";
    protected static final String ASYNC_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";
    protected static final String SYNC_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.synchronous.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testSingleActivityInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").done());
        this.completeTasksInOrder("task1");
        this.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testSingleActivityInstantiationById() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("task1")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").done());
        this.completeTasksInOrder("task1");
        this.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testSingleActivityInstantiationSetBusinessKey() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").businessKey("businessKey").startBeforeActivity("task1")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"businessKey", (String)instance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testSingleActivityInstantiationSetCaseInstanceId() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").caseInstanceId("caseInstanceId").startBeforeActivity("task1")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"caseInstanceId", (String)instance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testStartEventInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("theStart")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").done());
        this.completeTasksInOrder("task1");
        this.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testStartEventInstantiationWithVariables() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("theStart")).setVariable("aVariable", (Object)"aValue")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"aValue", (Object)this.runtimeService.getVariable(instance.getId(), "aVariable"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testStartWithInvalidInitialActivity() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("someNonExistingActivity")).execute();
            ProcessInstantiationAtActivitiesTest.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.assertTextPresentIgnoreCase("element 'someNonExistingActivity' does not exist in process ", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testMultipleActivitiesInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).startBeforeActivity("task2")).startBeforeActivity("task1")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").activity("task1").done());
        this.completeTasksInOrder("task1", "task2", "task1");
        this.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testMultipleActivitiesInstantiationWithVariables() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).setVariableLocal("aVar1", (Object)"aValue1")).startBeforeActivity("task2")).setVariableLocal("aVar2", (Object)"aValue2")).execute();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)task2Execution);
        ProcessInstantiationAtActivitiesTest.assertNull((Object)this.runtimeService.getVariableLocal(task2Execution.getId(), "aVar1"));
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"aValue2", (Object)this.runtimeService.getVariableLocal(task2Execution.getId(), "aVar2"));
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)task1Execution);
        ProcessInstantiationAtActivitiesTest.assertNull((Object)this.runtimeService.getVariableLocal(task1Execution.getId(), "aVar2"));
        ProcessInstantiationAtActivitiesTest.assertNull((Object)this.runtimeService.getVariableLocal(task1Execution.getId(), "aVar1"));
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"aValue1", (Object)this.runtimeService.getVariable(task1Execution.getId(), "aVar1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void testNestedActivitiesInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subprocess").startBeforeActivity("innerTask")).startBeforeActivity("outerTask")).startBeforeActivity("innerTask")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").activity("innerTask").done());
        this.completeTasksInOrder("innerTask", "innerTask", "outerTask", "innerTask");
        this.assertProcessEnded(instance.getId());
    }

    public void testStartNonExistingProcessDefinition() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById("I don't exist").startBeforeActivity("start")).execute();
            ProcessInstantiationAtActivitiesTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no deployed process definition found with id", e.getMessage());
        }
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("I don't exist either").startBeforeActivity("start")).execute();
            ProcessInstantiationAtActivitiesTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no processes deployed with key", e.getMessage());
        }
    }

    public void testStartNullProcessDefinition() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(null).startBeforeActivity("start")).execute();
            ProcessInstantiationAtActivitiesTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(null).startBeforeActivity("start")).execute();
            ProcessInstantiationAtActivitiesTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testStartProcessInstanceWithoutInstantiationInstruction() {
        try {
            this.runtimeService.createProcessInstanceByKey("exclusiveGateway").execute();
            ProcessInstantiationAtActivitiesTest.fail((String)"exception expected; at least one modification instruction required");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("At least one instantiation instruction required", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.listeners.bpmn20.xml"})
    public void testListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("listenerProcess").startBeforeActivity("innerTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").done());
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        ProcessInstantiationAtActivitiesTest.assertEquals((int)3, (int)events.size());
        RecorderExecutionListener.RecordedEvent processStartEvent = events.get(0);
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"start", (String)processStartEvent.getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"innerTask", (String)processStartEvent.getActivityId());
        RecorderExecutionListener.RecordedEvent subProcessStartEvent = events.get(1);
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"start", (String)subProcessStartEvent.getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"subProcess", (String)subProcessStartEvent.getActivityId());
        RecorderExecutionListener.RecordedEvent innerTaskStartEvent = events.get(2);
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"start", (String)innerTaskStartEvent.getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"innerTask", (String)innerTaskStartEvent.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.listeners.bpmn20.xml"})
    public void testSkipListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("listenerProcess").startBeforeActivity("innerTask")).execute(true, true);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").done());
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        ProcessInstantiationAtActivitiesTest.assertEquals((int)0, (int)events.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.ioMappings.bpmn20.xml"})
    public void testIoMappingInvocation() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("ioProcess").startBeforeActivity("innerTask")).execute();
        List variables = ((VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().asc()).list();
        ProcessInstantiationAtActivitiesTest.assertEquals((int)2, (int)variables.size());
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        VariableInstance innerTaskVariable = (VariableInstance)variables.get(0);
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"innerTaskVariable", (String)innerTaskVariable.getName());
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"innerTaskValue", (Object)innerTaskVariable.getValue());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)innerTaskExecution.getId(), (String)innerTaskVariable.getExecutionId());
        VariableInstance subProcessVariable = (VariableInstance)variables.get(1);
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"subProcessVariable", (String)subProcessVariable.getName());
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"subProcessValue", (Object)subProcessVariable.getValue());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)((ExecutionEntity)innerTaskExecution).getParentId(), (String)subProcessVariable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.ioMappings.bpmn20.xml"})
    public void testSkipIoMappingInvocation() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("ioProcess").startBeforeActivity("innerTask")).execute(true, true);
        ProcessInstantiationAtActivitiesTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void testSetProcessInstanceVariable() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subprocess").setVariable("aVariable1", (Object)"aValue1")).setVariableLocal("aVariable2", (Object)"aValue2")).setVariables((Map)Variables.createVariables().putValue("aVariable3", (Object)"aValue3"))).setVariablesLocal((Map)Variables.createVariables().putValue("aVariable4", (Object)"aValue4"))).startBeforeActivity("innerTask")).execute();
        List variables = ((VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().asc()).list();
        ProcessInstantiationAtActivitiesTest.assertEquals((int)4, (int)variables.size());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"aVariable1", (String)((VariableInstance)variables.get(0)).getName());
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"aValue1", (Object)((VariableInstance)variables.get(0)).getValue());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)instance.getId(), (String)((VariableInstance)variables.get(0)).getExecutionId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"aVariable2", (String)((VariableInstance)variables.get(1)).getName());
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"aValue2", (Object)((VariableInstance)variables.get(1)).getValue());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)instance.getId(), (String)((VariableInstance)variables.get(1)).getExecutionId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"aVariable3", (String)((VariableInstance)variables.get(2)).getName());
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"aValue3", (Object)((VariableInstance)variables.get(2)).getValue());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)instance.getId(), (String)((VariableInstance)variables.get(2)).getExecutionId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"aVariable4", (String)((VariableInstance)variables.get(3)).getName());
        ProcessInstantiationAtActivitiesTest.assertEquals((Object)"aValue4", (Object)((VariableInstance)variables.get(3)).getValue());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)instance.getId(), (String)((VariableInstance)variables.get(3)).getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    public void testStartAsyncTask() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task2")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).transition("task2").done());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.completeTasksInOrder("task2");
        this.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.synchronous.bpmn20.xml"})
    public void testStartMultipleTasksInSyncProcess() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("syncProcess").startBeforeActivity("syncTask")).startBeforeActivity("syncTask")).startBeforeActivity("syncTask")).execute();
        ProcessInstantiationAtActivitiesTest.assertNotNull((Object)instance);
        this.assertProcessEnded(instance.getId());
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        ProcessInstantiationAtActivitiesTest.assertEquals((int)8, (int)events.size());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"start", (String)events.get(0).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"syncTask", (String)events.get(0).getActivityId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"start", (String)events.get(1).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"syncTask", (String)events.get(1).getActivityId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"end", (String)events.get(2).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"syncTask", (String)events.get(2).getActivityId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"start", (String)events.get(3).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"syncTask", (String)events.get(3).getActivityId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"end", (String)events.get(4).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"syncTask", (String)events.get(4).getActivityId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"start", (String)events.get(5).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"syncTask", (String)events.get(5).getActivityId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"end", (String)events.get(6).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"syncTask", (String)events.get(6).getActivityId());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"end", (String)events.get(7).getEventName());
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"end", (String)events.get(7).getActivityId());
    }

    @Deployment
    public void testInitiatorVariable() {
        this.identityService.setAuthenticatedUserId("kermit");
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("initiatorProcess").startBeforeActivity("task")).execute();
        String initiator = (String)this.runtimeService.getVariable(instance.getId(), "initiator");
        ProcessInstantiationAtActivitiesTest.assertEquals((String)"kermit", (String)initiator);
        this.identityService.clearAuthentication();
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            ProcessInstantiationAtActivitiesTest.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

