/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ExecutionVariablesTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testTreeCompactionWithLocalVariableOnConcurrentExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Execution subProcessConcurrentExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(((ExecutionEntity)innerTaskExecution).getParentId()).singleResult();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.runtimeService.setVariableLocal(subProcessConcurrentExecution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task.getId());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        ExecutionVariablesTest.assertNotNull((Object)variable);
        ExecutionVariablesTest.assertEquals((String)"foo", (String)variable.getName());
        ExecutionVariablesTest.assertEquals((String)processInstance.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testTreeCompactionForkParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        ExecutionVariablesTest.assertNotNull((Object)variable);
        ExecutionVariablesTest.assertEquals((String)"foo", (String)variable.getName());
        ExecutionVariablesTest.assertEquals((String)processInstance.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testTreeCompactionNestedForkParallelGateway() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        String subProcessScopeExecutionId = ((ExecutionEntity)task2Execution).getParentId();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        ExecutionVariablesTest.assertNotNull((Object)variable);
        ExecutionVariablesTest.assertEquals((String)"foo", (String)variable.getName());
        ExecutionVariablesTest.assertEquals((String)subProcessScopeExecutionId, (String)variable.getExecutionId());
    }

    @Deployment
    public void FAILING_testForkWithThreeBranchesAndJoinOfTwoBranches() {
        this.runtimeService.startProcessInstanceByKey("process");
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult()).getId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult()).getId());
        ExecutionVariablesTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }
}

