/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.escalation;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.AssertionFailedError;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EscalationEventParseInvalidProcessTest {
    private static final String PROCESS_DEFINITION_DIRECTORY = "org/camunda/bpm/engine/test/bpmn/event/escalation/";
    @Parameterized.Parameter(value=0)
    public String processDefinitionResource;
    @Parameterized.Parameter(value=1)
    public String expectedErrorMessage;
    @Rule
    public ProcessEngineRule rule = new ProcessEngineRule(PluggableProcessEngineTestCase.getProcessEngine());
    protected RepositoryService repositoryService;

    @Parameterized.Parameters(name="{index}: process definition = {0}, expected error message = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"EscalationEventParseInvalidProcessTest.missingIdOnEscalation.bpmn20.xml", "escalation must have an id"}, {"EscalationEventParseInvalidProcessTest.invalidAttachement.bpmn20.xml", "An escalation boundary event should only be attached to a subprocess or a call activity"}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnBoundaryEvent.bpmn20.xml", "could not find escalation with id 'invalid-escalation'"}, {"EscalationEventParseInvalidProcessTest.multipleEscalationBoundaryEventsWithSameEscalationCode.bpmn20.xml", "multiple escalation boundary events with the same escalationCode 'escalationCode' are not supported on same scope"}, {"EscalationEventParseInvalidProcessTest.multipleEscalationBoundaryEventsWithAndWithoutEscalationCode.bpmn20.xml", "The same scope can not contains an escalation boundary event without escalation code and another one with escalation code."}, {"EscalationEventParseInvalidProcessTest.multipleEscalationBoundaryEventsWithoutEscalationCode.bpmn20.xml", "The same scope can not contains more than one escalation boundary event without escalation code."}, {"EscalationEventParseInvalidProcessTest.missingEscalationCodeOnIntermediateThrowingEscalationEvent.bpmn20.xml", "throwing escalation event must have an 'escalationCode'"}, {"EscalationEventParseInvalidProcessTest.missingEscalationRefOnIntermediateThrowingEvent.bpmn20.xml", "escalationEventDefinition does not have required attribute 'escalationRef'"}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnIntermediateThrowingEvent.bpmn20.xml", "could not find escalation with id 'invalid-escalation'"}, {"EscalationEventParseInvalidProcessTest.missingEscalationCodeOnEscalationEndEvent.bpmn20.xml", "escalation end event must have an 'escalationCode'"}, {"EscalationEventParseInvalidProcessTest.missingEscalationRefOnEndEvent.bpmn20.xml", "escalationEventDefinition does not have required attribute 'escalationRef'"}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnEndEvent.bpmn20.xml", "could not find escalation with id 'invalid-escalation'"}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnEscalationEventSubprocess.bpmn20.xml", "could not find escalation with id 'invalid-escalation'"}, {"EscalationEventParseInvalidProcessTest.multipleInterruptingEscalationEventSubprocesses.bpmn20.xml", "multiple escalation event subprocesses with the same escalationCode 'escalationCode' are not supported on same scope"}, {"EscalationEventParseInvalidProcessTest.multipleEscalationEventSubprocessWithSameEscalationCode.bpmn20.xml", "multiple escalation event subprocesses with the same escalationCode 'escalationCode' are not supported on same scope"}, {"EscalationEventParseInvalidProcessTest.multipleEscalationEventSubprocessWithAndWithoutEscalationCode.bpmn20.xml", "The same scope can not contains an escalation event subprocess without escalation code and another one with escalation code."}, {"EscalationEventParseInvalidProcessTest.multipleEscalationEventSubprocessWithoutEscalationCode.bpmn20.xml", "The same scope can not contains more than one escalation event subprocess without escalation code."});
    }

    @Before
    public void initServices() {
        this.repositoryService = this.rule.getRepositoryService();
    }

    @Test
    public void testParseInvalidProcessDefinition() {
        try {
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource(PROCESS_DEFINITION_DIRECTORY + this.processDefinitionResource).deploy().getId();
            this.repositoryService.deleteDeployment(deploymentId, true);
            Assert.fail((String)("exception expected: " + this.expectedErrorMessage));
        }
        catch (Exception e) {
            this.assertExceptionMessageContainsText(e, this.expectedErrorMessage);
        }
    }

    public void assertExceptionMessageContainsText(Exception e, String expectedMessage) {
        String actualMessage = e.getMessage();
        if (actualMessage == null || !actualMessage.contains(expectedMessage)) {
            throw new AssertionFailedError("expected presence of [" + expectedMessage + "], but was [" + actualMessage + "]");
        }
    }
}

