/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.exclusive;

import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class ExclusiveTaskTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testNonExclusiveService() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ExclusiveTaskTest.assertNotNull((Object)job);
        ExclusiveTaskTest.assertFalse((boolean)((JobEntity)job).isExclusive());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveService() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ExclusiveTaskTest.assertNotNull((Object)job);
        ExclusiveTaskTest.assertTrue((boolean)((JobEntity)job).isExclusive());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveServiceConcurrent() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        ExclusiveTaskTest.assertEquals((long)3L, (long)this.managementService.createJobQuery().count());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveSequence2() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveSequence3() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }
}

