/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.sequenceflow;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class UncontrolledFlowTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSubProcessTwoOutgoingFlowsCorrelateMessage() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        UncontrolledFlowTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        UncontrolledFlowTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("outerTask1").count());
        UncontrolledFlowTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("outerTask2").count());
        try {
            this.runtimeService.correlateMessage("Message1");
            UncontrolledFlowTest.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot correlate message Message1", e.getMessage());
        }
    }

    @Deployment
    public void testSubProcessTwoOutgoingFlowsEndProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.assertProcessEnded(processInstance.getId());
    }
}

